package com.wflower.AntiAttrition;

import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.server.MinecraftServer;

public class ServerSaveManager {
    private boolean lowLoadMode = false;
    private int tickCounter = 0;
    private static final int LOW_LOAD_SAVE_INTERVAL = 120000; // 100分钟（120000刻）
    private static final int NORMAL_SAVE_INTERVAL = 6000;    // 5分钟（6000刻）

    public void setLowLoadMode(boolean enabled) {
        this.lowLoadMode = enabled;
        this.tickCounter = 0;
    }

    public boolean isLowLoadMode() {
        return lowLoadMode;
    }

    public void onLowLoadTick(MinecraftServer server) {
        tickCounter++;

        // 在低负载模式下，减少保存频率
        if (tickCounter >= LOW_LOAD_SAVE_INTERVAL) {
            performLowLoadSave(server);
            tickCounter = 0;
        }
    }

    private void performLowLoadSave(MinecraftServer server) {
        AntiAttrition.LOGGER.info("Performing low-load mode save...");

        try {
            // 保存玩家数据
            server.method_3760().method_14617();

            // 保存世界数据，但减少频率
            for (class_3218 world : server.method_3738()) {
                if (world != null) {
                    // 只保存重要的世界数据，跳过区块数据
                    class_5268 properties = (class_5268) world.method_8401();
                    properties.method_29034(world.method_8510());
                    properties.method_29035(world.method_8532());

                    // 不强制保存区块，让它们在需要时自动保存
                    world.field_13957 = false;
                    world.method_14176(null, false, false);
                    world.field_13957 = true;
                }
            }

            AntiAttrition.LOGGER.info("Low-load mode save completed");
        } catch (Exception e) {
            AntiAttrition.LOGGER.error("Error during low-load save", e);
        }
    }

    public void resetTickCounter() {
        this.tickCounter = 0;
    }
}