package com.wflower.AntiAttrition;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiAttrition implements ModInitializer {
    public static final String MOD_ID = "antiattrition";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    private static ServerSaveManager saveManager;
    private static boolean wasLowLoadMode = false;

    @Override
    public void onInitialize() {
        LOGGER.info("AntiAttrition mod initializing...");

        // 初始化保存管理器
        saveManager = new ServerSaveManager();

        // 注册服务器刻事件
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);

        // 注册玩家连接/断开事件
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            onPlayerJoin(server, handler.field_14140);
        });

        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            onPlayerLeave(server);
        });

        LOGGER.info("AntiAttrition mod initialized successfully!");
    }

    private void onServerTick(MinecraftServer server) {
        // 每100刻（5秒）检查一次
        if (server.method_3780() % 100 == 0) {
            checkServerLoad(server);
        }
    }

    private void onPlayerJoin(MinecraftServer server, class_3222 player) {
        LOGGER.info("Player joined: {}", player.method_5477().getString());
        checkServerLoad(server);

        // 如果处于低负载模式，通知玩家
        if (saveManager.isLowLoadMode()) {
            player.method_7353(class_2561.method_43470("§e[AntiAttrition] Server is in low-load mode (only bot players detected)"), false);
        }
    }

    private void onPlayerLeave(MinecraftServer server) {
        LOGGER.info("Player left, checking server load...");
        checkServerLoad(server);
    }

    private void checkServerLoad(MinecraftServer server) {
        boolean hasNonBotPlayers = server.method_3760().method_14571().stream()
                .anyMatch(player -> !player.method_5477().getString().toLowerCase().startsWith("bot_"));

        boolean shouldUseLowLoadMode = !hasNonBotPlayers && !server.method_3760().method_14571().isEmpty();

        if (shouldUseLowLoadMode != wasLowLoadMode) {
            if (shouldUseLowLoadMode) {
                LOGGER.info("Entering low-load mode: only bot players online");
                enableLowLoadMode(server);
            } else {
                LOGGER.info("Exiting low-load mode: non-bot players detected");
                disableLowLoadMode(server);
            }
            wasLowLoadMode = shouldUseLowLoadMode;
        }

        if (saveManager.isLowLoadMode()) {
            saveManager.onLowLoadTick(server);
        }
    }

    private void enableLowLoadMode(MinecraftServer server) {
        saveManager.setLowLoadMode(true);

        // 通知所有玩家
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(class_2561.method_43470("§e[AntiAttrition] 低负载模式激活喵，服务器要好好保养喵"), false);
        }

        // 立即执行一次保存以清除缓存
        server.execute(() -> {
            server.method_3723(false, false, false);
            LOGGER.info("Saved world");
        });
    }

    private void disableLowLoadMode(MinecraftServer server) {
        saveManager.setLowLoadMode(false);

        // 通知所有玩家
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(class_2561.method_43470("§a[AntiAttrition] 低负载模式解除...呜呜呜...又要努力干活了呜呜呜..."), false);
        }
    }

    public static ServerSaveManager getSaveManager() {
        return saveManager;
    }
}