/*
 * Decompiled with CFR 0.152.
 */
package com.wflower.AntiAttrition;

import com.wflower.AntiAttrition.AntiAttrition;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.server.MinecraftServer;

public class ServerSaveManager {
    private boolean lowLoadMode = false;
    private int tickCounter = 0;
    private static final int LOW_LOAD_SAVE_INTERVAL = 120000;
    private static final int NORMAL_SAVE_INTERVAL = 6000;

    public void setLowLoadMode(boolean enabled) {
        this.lowLoadMode = enabled;
        this.tickCounter = 0;
    }

    public boolean isLowLoadMode() {
        return this.lowLoadMode;
    }

    public void onLowLoadTick(MinecraftServer server) {
        ++this.tickCounter;
        if (this.tickCounter >= 120000) {
            this.performLowLoadSave(server);
            this.tickCounter = 0;
        }
    }

    private void performLowLoadSave(MinecraftServer server) {
        AntiAttrition.LOGGER.info("Performing low-load mode save...");
        try {
            server.method_3760().method_14617();
            for (class_3218 world : server.method_3738()) {
                if (world == null) continue;
                class_5268 properties = (class_5268)world.method_8401();
                properties.method_29034(world.method_8510());
                properties.method_29035(world.method_8532());
                world.field_13957 = false;
                world.method_14176(null, false, false);
                world.field_13957 = true;
            }
            AntiAttrition.LOGGER.info("Low-load mode save completed");
        }
        catch (Exception e) {
            AntiAttrition.LOGGER.error("Error during low-load save", (Throwable)e);
        }
    }

    public void resetTickCounter() {
        this.tickCounter = 0;
    }
}

