/*
 * Decompiled with CFR 0.152.
 */
package com.wflower.AntiAttrition;

import com.wflower.AntiAttrition.ServerSaveManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiAttrition
implements ModInitializer {
    public static final String MOD_ID = "antiattrition";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"antiattrition");
    private static ServerSaveManager saveManager;
    private static boolean wasLowLoadMode;

    public void onInitialize() {
        LOGGER.info("AntiAttrition mod initializing...");
        saveManager = new ServerSaveManager();
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.onPlayerJoin(server, handler.field_14140));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.onPlayerLeave(server));
        LOGGER.info("AntiAttrition mod initialized successfully!");
    }

    private void onServerTick(MinecraftServer server) {
        if (server.method_3780() % 100 == 0) {
            this.checkServerLoad(server);
        }
    }

    private void onPlayerJoin(MinecraftServer server, class_3222 player) {
        LOGGER.info("Player joined: {}", (Object)player.method_5477().getString());
        this.checkServerLoad(server);
        if (saveManager.isLowLoadMode()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e[AntiAttrition] Server is in low-load mode (only bot players detected)"), false);
        }
    }

    private void onPlayerLeave(MinecraftServer server) {
        LOGGER.info("Player left, checking server load...");
        this.checkServerLoad(server);
    }

    private void checkServerLoad(MinecraftServer server) {
        boolean shouldUseLowLoadMode;
        boolean hasNonBotPlayers = server.method_3760().method_14571().stream().anyMatch(player -> !player.method_5477().getString().toLowerCase().startsWith("bot_"));
        boolean bl = shouldUseLowLoadMode = !hasNonBotPlayers && !server.method_3760().method_14571().isEmpty();
        if (shouldUseLowLoadMode != wasLowLoadMode) {
            if (shouldUseLowLoadMode) {
                LOGGER.info("Entering low-load mode: only bot players online");
                this.enableLowLoadMode(server);
            } else {
                LOGGER.info("Exiting low-load mode: non-bot players detected");
                this.disableLowLoadMode(server);
            }
            wasLowLoadMode = shouldUseLowLoadMode;
        }
        if (saveManager.isLowLoadMode()) {
            saveManager.onLowLoadTick(server);
        }
    }

    private void enableLowLoadMode(MinecraftServer server) {
        saveManager.setLowLoadMode(true);
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e[AntiAttrition] \u4f4e\u8d1f\u8f7d\u6a21\u5f0f\u6fc0\u6d3b\u55b5\uff0c\u670d\u52a1\u5668\u8981\u597d\u597d\u4fdd\u517b\u55b5"), false);
        }
        server.execute(() -> {
            server.method_3723(false, false, false);
            LOGGER.info("Saved world");
        });
    }

    private void disableLowLoadMode(MinecraftServer server) {
        saveManager.setLowLoadMode(false);
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a[AntiAttrition] \u4f4e\u8d1f\u8f7d\u6a21\u5f0f\u89e3\u9664...\u545c\u545c\u545c...\u53c8\u8981\u52aa\u529b\u5e72\u6d3b\u4e86\u545c\u545c\u545c..."), false);
        }
    }

    public static ServerSaveManager getSaveManager() {
        return saveManager;
    }

    static {
        wasLowLoadMode = false;
    }
}

