/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.xz;

import java.io.InputStream;
import no.jckf.dhsupport.xz.ArrayCache;
import no.jckf.dhsupport.xz.BCJCoder;
import no.jckf.dhsupport.xz.FilterDecoder;
import no.jckf.dhsupport.xz.SimpleInputStream;
import no.jckf.dhsupport.xz.UnsupportedOptionsException;
import no.jckf.dhsupport.xz.simple.ARM;
import no.jckf.dhsupport.xz.simple.ARM64;
import no.jckf.dhsupport.xz.simple.ARMThumb;
import no.jckf.dhsupport.xz.simple.IA64;
import no.jckf.dhsupport.xz.simple.PowerPC;
import no.jckf.dhsupport.xz.simple.RISCVDecoder;
import no.jckf.dhsupport.xz.simple.SPARC;
import no.jckf.dhsupport.xz.simple.SimpleFilter;
import no.jckf.dhsupport.xz.simple.X86;

class BCJDecoder
extends BCJCoder
implements FilterDecoder {
    private final long filterID;
    private final int startOffset;

    BCJDecoder(long filterID, byte[] props) throws UnsupportedOptionsException {
        assert (BCJDecoder.isBCJFilterID(filterID));
        this.filterID = filterID;
        if (props.length == 0) {
            this.startOffset = 0;
        } else if (props.length == 4) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n |= (props[i] & 0xFF) << i * 8;
            }
            this.startOffset = n;
        } else {
            throw new UnsupportedOptionsException("Unsupported BCJ filter properties");
        }
    }

    @Override
    public int getMemoryUsage() {
        return SimpleInputStream.getMemoryUsage();
    }

    @Override
    public InputStream getInputStream(InputStream in, ArrayCache arrayCache) {
        SimpleFilter simpleFilter = null;
        if (this.filterID == 4L) {
            simpleFilter = new X86(false, this.startOffset);
        } else if (this.filterID == 5L) {
            simpleFilter = new PowerPC(false, this.startOffset);
        } else if (this.filterID == 6L) {
            simpleFilter = new IA64(false, this.startOffset);
        } else if (this.filterID == 7L) {
            simpleFilter = new ARM(false, this.startOffset);
        } else if (this.filterID == 8L) {
            simpleFilter = new ARMThumb(false, this.startOffset);
        } else if (this.filterID == 9L) {
            simpleFilter = new SPARC(false, this.startOffset);
        } else if (this.filterID == 10L) {
            simpleFilter = new ARM64(false, this.startOffset);
        } else if (this.filterID == 11L) {
            simpleFilter = new RISCVDecoder(this.startOffset);
        } else assert (false);
        return new SimpleInputStream(in, simpleFilter);
    }
}

