/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.lodbuilders;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import no.jckf.dhsupport.core.Coordinates;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import no.jckf.dhsupport.core.dataobject.Beacon;
import no.jckf.dhsupport.core.dataobject.DataPoint;
import no.jckf.dhsupport.core.dataobject.IdMapping;
import no.jckf.dhsupport.core.dataobject.Lod;
import no.jckf.dhsupport.core.dataobject.SectionPosition;
import no.jckf.dhsupport.core.lodbuilders.LodBuilder;
import no.jckf.dhsupport.core.world.WorldInterface;

public class FullBuilder
extends LodBuilder {
    public FullBuilder(WorldInterface worldInterface, SectionPosition position) {
        super(worldInterface, position);
    }

    @Override
    public Lod generate() {
        int yStep;
        int minY = this.worldInterface.getMinY();
        int maxY = this.worldInterface.getMaxY();
        int height = maxY - minY;
        int offsetX = Coordinates.sectionToBlock(this.position.getX());
        int offsetZ = Coordinates.sectionToBlock(this.position.getZ());
        int originalStep = yStep = 1;
        boolean includeNonCollidingTopLayer = this.worldInterface.getConfig().getBool(DhsConfig.INCLUDE_NON_COLLIDING_TOP_LAYER, true);
        boolean performUnderglowHack = this.worldInterface.getConfig().getBool(DhsConfig.PERFORM_UNDERGLOW_HACK, false);
        boolean sampleBiomes3d = this.worldInterface.getConfig().getBool(DhsConfig.SAMPLE_BIOMES_3D, false);
        ArrayList<IdMapping> idMappings = new ArrayList<IdMapping>();
        HashMap<CallSite, Integer> mapMap = new HashMap<CallSite, Integer>();
        ArrayList<List<DataPoint>> columns = new ArrayList<List<DataPoint>>();
        ArrayList<Beacon> beacons = new ArrayList<Beacon>();
        for (int relativeX = 0; relativeX < Lod.width; ++relativeX) {
            for (int relativeZ = 0; relativeZ < Lod.width; ++relativeZ) {
                int firstY;
                int topLayer;
                int worldX = offsetX + relativeX;
                int worldZ = offsetZ + relativeZ;
                int hardTopLayer = topLayer = this.worldInterface.getHighestYAt(worldX, worldZ);
                if (includeNonCollidingTopLayer) {
                    block9: while (topLayer + 1 < maxY) {
                        String topSample;
                        switch (topSample = this.worldInterface.getMaterialAt(worldX, topLayer + 1, worldZ)) {
                            case "minecraft:air": 
                            case "minecraft:void_air": {
                                break block9;
                            }
                            default: {
                                ++topLayer;
                                continue block9;
                            }
                        }
                    }
                }
                if (topLayer != hardTopLayer) {
                    yStep = 1;
                }
                int relativeTopLayer = topLayer - minY;
                String biome = "";
                if (!sampleBiomes3d) {
                    biome = this.worldInterface.getBiomeAt(worldX, worldZ);
                }
                ArrayList<DataPoint> column = new ArrayList<DataPoint>();
                DataPoint previous = null;
                for (int relativeY = firstY = height - yStep; relativeY >= 1 - yStep; relativeY -= yStep) {
                    DataPoint point;
                    String compositeKey;
                    Integer id;
                    int lowWorldY;
                    int highWorldY;
                    int thisStep = yStep;
                    if (relativeY < 0) {
                        thisStep -= -relativeY;
                        relativeY = 0;
                    }
                    if ((highWorldY = (lowWorldY = minY + relativeY) + thisStep - 1) == hardTopLayer) {
                        yStep = originalStep;
                    }
                    String material = this.worldInterface.getMaterialAt(worldX, highWorldY, worldZ);
                    if (this.worldInterface.isBeacon(worldX, highWorldY, worldZ)) {
                        beacons.add(new Beacon(worldX, highWorldY, worldZ, this.worldInterface.getBeaconColor(worldX, highWorldY, worldZ)));
                    }
                    if (sampleBiomes3d) {
                        biome = this.worldInterface.getBiomeAt(worldX, highWorldY, worldZ);
                    }
                    if ((id = (Integer)mapMap.get(compositeKey = biome + "|" + material + "|" + this.worldInterface.getBlockStateAsStringAt(worldX, highWorldY, worldZ))) == null) {
                        idMappings.add(new IdMapping(biome, material, this.worldInterface.getBlockPropertiesAt(worldX, highWorldY, worldZ)));
                        id = idMappings.size() - 1;
                        mapMap.put((CallSite)((Object)compositeKey), id);
                    }
                    if (previous != null && previous.getMappingId() == id.intValue()) {
                        point = previous;
                        point.setStartY(point.getStartY() - thisStep);
                        point.setHeight(point.getHeight() + thisStep);
                    } else {
                        point = new DataPoint();
                        column.add(point);
                        point.setStartY(relativeY);
                        point.setHeight(thisStep);
                        point.setMappingId(id);
                        if (highWorldY + 1 < maxY) {
                            point.setSkyLight(this.worldInterface.getSkyLightAt(worldX, highWorldY + 1, worldZ));
                            point.setBlockLight(this.worldInterface.getBlockLightAt(worldX, highWorldY + 1, worldZ));
                        }
                        if (material.equals("minecraft:air") || material.equals("minecraft:void_air")) {
                            if (relativeY == firstY) {
                                point.setStartY(relativeTopLayer + 1);
                                point.setHeight(height - relativeTopLayer);
                                relativeY = point.getStartY();
                            } else {
                                yStep = 1;
                                if (performUnderglowHack && previous != null && previous.getHeight() > 2) {
                                    previous.setStartY(previous.getStartY() + 2);
                                    previous.setHeight(previous.getHeight() - 2);
                                    DataPoint bottomBlock = new DataPoint();
                                    bottomBlock.setMappingId(previous.getMappingId());
                                    bottomBlock.setStartY(relativeY + 1);
                                    bottomBlock.setHeight(1);
                                    bottomBlock.setSkyLight(this.worldInterface.getSkyLightAt(worldX, lowWorldY, worldZ));
                                    bottomBlock.setBlockLight(this.worldInterface.getBlockLightAt(worldX, lowWorldY, worldZ));
                                    column.add(bottomBlock);
                                    previous = bottomBlock;
                                }
                            }
                        } else {
                            yStep = originalStep;
                        }
                    }
                    previous = point;
                }
                columns.add(column);
            }
        }
        return new Lod(this.worldInterface, this.position, idMappings, columns, beacons);
    }
}

