/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.handler;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import no.jckf.dhsupport.core.Coordinates;
import no.jckf.dhsupport.core.DhSupport;
import no.jckf.dhsupport.core.configuration.Configuration;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import no.jckf.dhsupport.core.dataobject.SectionPosition;
import no.jckf.dhsupport.core.handler.PluginMessageHandler;
import no.jckf.dhsupport.core.message.plugin.ExceptionMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataChunkMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataSourceRequestMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataSourceResponseMessage;
import no.jckf.dhsupport.core.message.plugin.TrackablePluginMessage;
import no.jckf.dhsupport.core.world.WorldInterface;
import org.bukkit.Bukkit;

public class LodHandler {
    public static int CHUNK_SIZE = 16384;
    protected DhSupport dhSupport;
    protected PluginMessageHandler pluginMessageHandler;

    public LodHandler(DhSupport dhSupport, PluginMessageHandler pluginMessageHandler) {
        this.dhSupport = dhSupport;
        this.pluginMessageHandler = pluginMessageHandler;
    }

    public void register() {
        this.pluginMessageHandler.getEventBus().registerHandler(FullDataSourceRequestMessage.class, requestMessage -> {
            if (requestMessage.getPosition().getDetailLevel() != 6) {
                ExceptionMessage exceptionMessage = new ExceptionMessage();
                exceptionMessage.isResponseTo((TrackablePluginMessage)requestMessage);
                exceptionMessage.setTypeId(ExceptionMessage.TYPE_SECTION_REQUIRES_SPLITTING);
                exceptionMessage.setMessage("Only detail level 6 is supported");
                this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), exceptionMessage);
                return;
            }
            UUID worldUuid = Bukkit.getPlayer((UUID)requestMessage.getSender()).getWorld().getUID();
            WorldInterface world = this.dhSupport.getWorldInterface(worldUuid);
            Configuration config = world.getConfig();
            Configuration playerConfig = this.dhSupport.getPlayerConfiguration(requestMessage.getSender());
            if (!config.getBool(DhsConfig.DISTANT_GENERATION_ENABLED).booleanValue() || !playerConfig.getBool(DhsConfig.DISTANT_GENERATION_ENABLED).booleanValue()) {
                ExceptionMessage exceptionMessage = new ExceptionMessage();
                exceptionMessage.isResponseTo((TrackablePluginMessage)requestMessage);
                exceptionMessage.setTypeId(ExceptionMessage.TYPE_SECTION_REQUIRES_SPLITTING);
                exceptionMessage.setMessage("Server has disabled distant generation");
                this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), exceptionMessage);
                return;
            }
            SectionPosition position = requestMessage.getPosition();
            String builderType = config.getString(DhsConfig.BUILDER_TYPE);
            if (builderType.equalsIgnoreCase("none") && !this.dhSupport.getLodRepository().lodExists(worldUuid, position.getX(), position.getZ())) {
                ExceptionMessage exceptionMessage = new ExceptionMessage();
                exceptionMessage.isResponseTo((TrackablePluginMessage)requestMessage);
                exceptionMessage.setTypeId(ExceptionMessage.TYPE_REQUEST_REJECTED);
                exceptionMessage.setMessage("Server has disabled LOD builder");
                this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), exceptionMessage);
                return;
            }
            int worldX = Coordinates.sectionToBlock(position.getX());
            int worldZ = Coordinates.sectionToBlock(position.getZ());
            Integer borderCenterX = world.getWorldBorderX();
            Integer borderCenterZ = world.getWorldBorderZ();
            Integer borderRadius = world.getWorldBorderRadius();
            if (borderCenterX != null && borderCenterZ != null && borderRadius != null) {
                int minX = borderCenterX - borderRadius;
                int maxX = borderCenterX + borderRadius;
                int minZ = borderCenterZ - borderRadius;
                int maxZ = borderCenterZ + borderRadius;
                int higherLodX = worldX + 64;
                int higherLodZ = worldZ + 64;
                if (higherLodX < minX || worldX > maxX || higherLodZ < minZ || worldZ > maxZ) {
                    ExceptionMessage exceptionMessage = new ExceptionMessage();
                    exceptionMessage.isResponseTo((TrackablePluginMessage)requestMessage);
                    exceptionMessage.setTypeId(ExceptionMessage.TYPE_REQUEST_REJECTED);
                    exceptionMessage.setMessage("World border");
                    this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), exceptionMessage);
                    return;
                }
            }
            ((CompletableFuture)this.dhSupport.getLod(worldUuid, position).thenAccept(lodModel -> {
                boolean sendData;
                if (lodModel == null) {
                    ExceptionMessage exceptionMessage = new ExceptionMessage();
                    exceptionMessage.isResponseTo((TrackablePluginMessage)requestMessage);
                    exceptionMessage.setTypeId(ExceptionMessage.TYPE_REQUEST_REJECTED);
                    exceptionMessage.setMessage("No LOD available");
                    this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), exceptionMessage);
                    return;
                }
                FullDataSourceResponseMessage responseMessage = new FullDataSourceResponseMessage();
                responseMessage.isResponseTo((TrackablePluginMessage)requestMessage);
                boolean bl = sendData = requestMessage.getTimestamp() == null || requestMessage.getTimestamp() / 1000L < (long)lodModel.getTimestamp();
                if (sendData) {
                    int myBufferId = playerConfig.increment("buffer-id");
                    responseMessage.setBufferId(myBufferId);
                    responseMessage.setBeacons(lodModel.getBeacons());
                    byte[] data = lodModel.getData();
                    int chunkCount = (int)Math.ceil((double)data.length / (double)CHUNK_SIZE);
                    for (int chunkNo = 0; chunkNo < chunkCount; ++chunkNo) {
                        FullDataChunkMessage chunkResponse = new FullDataChunkMessage();
                        chunkResponse.setBufferId(myBufferId);
                        chunkResponse.setIsFirst(chunkNo == 0);
                        chunkResponse.setData(Arrays.copyOfRange(data, CHUNK_SIZE * chunkNo, Math.min(CHUNK_SIZE * chunkNo + CHUNK_SIZE, data.length)));
                        this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), chunkResponse);
                    }
                }
                this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), responseMessage);
            })).exceptionally(exception -> {
                exception.printStackTrace();
                ExceptionMessage exceptionMessage = new ExceptionMessage();
                exceptionMessage.isResponseTo((TrackablePluginMessage)requestMessage);
                exceptionMessage.setTypeId(ExceptionMessage.TYPE_REQUEST_REJECTED);
                exceptionMessage.setMessage("Internal error");
                this.pluginMessageHandler.sendPluginMessage(requestMessage.getSender(), exceptionMessage);
                return null;
            });
        });
    }
}

