/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.jckf.dhsupport.core.event.EventHandler;

public class EventBus<E> {
    protected Map<Class, List<EventHandler>> handlers = new HashMap<Class, List<EventHandler>>();

    public <T extends E> void registerHandler(Class<T> eventClass, EventHandler<T> handler) {
        if (!this.handlers.containsKey(eventClass)) {
            this.handlers.put(eventClass, new ArrayList());
        }
        this.handlers.get(eventClass).add(handler);
    }

    public <T extends E> void unregisterHandler(Class<T> eventClass, EventHandler<T> handler) {
        if (!this.handlers.containsKey(eventClass)) {
            return;
        }
        this.handlers.get(eventClass).remove(handler);
    }

    public <T extends E> void dispatch(T event) {
        if (!this.handlers.containsKey(event.getClass())) {
            return;
        }
        this.handlers.get(event.getClass()).forEach(handler -> handler.handle(event));
    }
}

