/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.dataobject;

import no.jckf.dhsupport.core.bytestream.Decoder;
import no.jckf.dhsupport.core.bytestream.Encoder;
import no.jckf.dhsupport.core.dataobject.DataObject;

public class SectionPosition
extends DataObject {
    public static final int DETAIL_LEVEL_OFFSET = 0;
    public static final int DETAIL_LEVEL_BITS = 8;
    public static final long DETAIL_LEVEL_MASK = 255L;
    public static final int X_OFFSET = 8;
    public static final int X_BITS = 28;
    public static final long X_MASK = 0xFFFFFFFL;
    public static final int Z_OFFSET = 36;
    public static final int Z_BITS = 28;
    public static final long Z_MASK = 0xFFFFFFFL;
    protected long data = 0L;

    public void setDetailLevel(int detailLevel) {
        this.data &= 0xFFFFFFFFFFFFFF00L;
        this.data |= ((long)detailLevel & 0xFFL) << 0;
    }

    public int getDetailLevel() {
        return (int)(this.data & 0xFFL);
    }

    public void setX(int x) {
        this.data &= 0xFFFFFFF0000000FFL;
        this.data |= ((long)x & 0xFFFFFFFL) << 8;
    }

    public int getX() {
        int raw = (int)(this.data >> 8 & 0xFFFFFFFL);
        if ((raw & 0x8000000) != 0) {
            raw |= 0xF0000000;
        }
        return raw;
    }

    public void setZ(int z) {
        this.data &= 0xFFFFFFFFFL;
        this.data |= ((long)z & 0xFFFFFFFL) << 36;
    }

    public int getZ() {
        int raw = (int)(this.data >> 36 & 0xFFFFFFFL);
        if ((raw & 0x8000000) != 0) {
            raw |= 0xF0000000;
        }
        return raw;
    }

    @Override
    public void encode(Encoder encoder) {
        encoder.writeLong(this.data);
    }

    @Override
    public void decode(Decoder decoder) {
        this.data = decoder.readLong();
    }
}

