/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.dataobject;

import no.jckf.dhsupport.core.bytestream.Decoder;
import no.jckf.dhsupport.core.bytestream.Encoder;
import no.jckf.dhsupport.core.dataobject.DataObject;

public class DataPoint
extends DataObject {
    protected static int MAPPING_ID_OFFSET = 0;
    protected static int MAPPING_ID_BITS = 32;
    protected static long MAPPING_ID_MASK = 0xFFFFFFFFL;
    protected static int HEIGHT_OFFSET = MAPPING_ID_OFFSET + MAPPING_ID_BITS;
    protected static int HEIGHT_BITS = 12;
    protected static long HEIGHT_MASK = 4095L;
    protected static int START_Y_OFFSET = HEIGHT_OFFSET + HEIGHT_BITS;
    protected static int START_Y_BITS = 12;
    protected static long START_Y_MASK = 4095L;
    protected static int SKY_LIGHT_OFFSET = START_Y_OFFSET + START_Y_BITS;
    protected static int SKY_LIGHT_BITS = 4;
    protected static long SKY_LIGHT_MASK = 15L;
    protected static int BLOCK_LIGHT_OFFSET = SKY_LIGHT_OFFSET + SKY_LIGHT_BITS;
    protected static int BLOCK_LIGHT_BITS = 4;
    protected static long BLOCK_LIGHT_MASK = 15L;
    protected long data = 0L;

    public void setMappingId(int mappingId) {
        this.data &= MAPPING_ID_MASK << MAPPING_ID_OFFSET ^ 0xFFFFFFFFFFFFFFFFL;
        this.data |= (long)mappingId & MAPPING_ID_MASK;
    }

    public int getMappingId() {
        return (int)(this.data >> MAPPING_ID_OFFSET & MAPPING_ID_MASK);
    }

    public void setHeight(int height) {
        this.data &= HEIGHT_MASK << HEIGHT_OFFSET ^ 0xFFFFFFFFFFFFFFFFL;
        this.data |= ((long)height & HEIGHT_MASK) << HEIGHT_OFFSET;
    }

    public int getHeight() {
        return (int)(this.data >> HEIGHT_OFFSET & HEIGHT_MASK);
    }

    public void setStartY(int startY) {
        this.data &= START_Y_MASK << START_Y_OFFSET ^ 0xFFFFFFFFFFFFFFFFL;
        this.data |= ((long)startY & START_Y_MASK) << START_Y_OFFSET;
    }

    public int getStartY() {
        int raw = (int)(this.data >> START_Y_OFFSET & START_Y_MASK);
        if ((raw & 0x800) != 0) {
            raw |= (int)(START_Y_MASK ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return raw;
    }

    public void setSkyLight(byte skyLight) {
        this.data &= SKY_LIGHT_MASK << SKY_LIGHT_OFFSET ^ 0xFFFFFFFFFFFFFFFFL;
        this.data |= ((long)skyLight & SKY_LIGHT_MASK) << SKY_LIGHT_OFFSET;
    }

    public byte getSkyLight() {
        return (byte)(this.data >> SKY_LIGHT_OFFSET & SKY_LIGHT_MASK);
    }

    public void setBlockLight(byte blockLight) {
        this.data &= BLOCK_LIGHT_MASK << BLOCK_LIGHT_OFFSET ^ 0xFFFFFFFFFFFFFFFFL;
        this.data |= ((long)blockLight & BLOCK_LIGHT_MASK) << BLOCK_LIGHT_OFFSET;
    }

    public byte getBlockLight() {
        return (byte)(this.data >> BLOCK_LIGHT_OFFSET & BLOCK_LIGHT_MASK);
    }

    @Override
    public void encode(Encoder encoder) {
        encoder.writeLong(this.data);
    }

    @Override
    public void decode(Decoder decoder) {
        this.data = decoder.readLong();
    }
}

