/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import no.jckf.dhsupport.core.database.migrations.Migration;

public class Database {
    protected String path;
    protected Connection connection;
    protected Map<String, PreparedStatement> preparedStatements = new ConcurrentHashMap<String, PreparedStatement>();
    protected Map<String, Class<? extends Migration>> migrations = new HashMap<String, Class<? extends Migration>>();
    protected CompletableFuture<?> optimizing;

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.path);
        }
        return this.connection;
    }

    public void open(String path) throws SQLException {
        this.path = path;
        this.getConnection();
    }

    public void close() throws SQLException {
        this.clearQueryCache();
        if (this.connection == null || this.connection.isClosed()) {
            return;
        }
        this.getConnection().close();
    }

    public PreparedStatement prepareAndReuse(String sql) throws SQLException {
        this.waitForOptimization();
        if (!this.preparedStatements.containsKey(sql)) {
            this.preparedStatements.put(sql, this.getConnection().prepareStatement(sql));
        }
        return this.preparedStatements.get(sql);
    }

    public void clearQueryCache() {
        for (String key : this.preparedStatements.keySet()) {
            try {
                this.preparedStatements.remove(key).close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void createMigrationsTable() throws SQLException {
        String sql = "    CREATE TABLE IF NOT EXISTS migrations (\n        name STRING PRIMARY KEY,\n        timestamp INTEGER\n    );\n";
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute(sql);
        }
    }

    public void addMigration(Class<? extends Migration> migration) {
        this.migrations.put(migration.getSimpleName(), migration);
    }

    public boolean hasMigrationRan(String name) throws SQLException {
        String sql = "SELECT 1 FROM migrations WHERE name = ?;";
        try (PreparedStatement statement = this.getConnection().prepareStatement(sql);){
            statement.setString(1, name);
            ResultSet result = statement.executeQuery();
            boolean bl = result.next();
            return bl;
        }
    }

    public void markMigrationAsRan(String name) throws SQLException {
        String sql = "INSERT INTO migrations (name, timestamp) VALUES (?, ?);";
        try (PreparedStatement statement = this.getConnection().prepareStatement(sql);){
            statement.setString(1, name);
            statement.setInt(2, (int)(System.currentTimeMillis() / 1000L));
            statement.executeUpdate();
        }
    }

    public void migrate() throws Exception {
        this.createMigrationsTable();
        for (String name : this.migrations.keySet()) {
            if (this.hasMigrationRan(name)) continue;
            Migration migration = this.migrations.get(name).getConstructor(this.getClass()).newInstance(this);
            migration.up();
            this.markMigrationAsRan(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() throws Exception {
        this.optimizing = new CompletableFuture();
        this.clearQueryCache();
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute("PRAGMA optimize");
            statement.execute("ANALYZE");
            statement.execute("REINDEX");
            statement.execute("VACUUM");
        }
        finally {
            this.optimizing.complete(null);
            this.optimizing = null;
        }
    }

    public void waitForOptimization() {
        if (this.optimizing != null) {
            this.optimizing.join();
        }
    }
}

