/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.bytestream;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import no.jckf.dhsupport.core.bytestream.Encodable;

public class Encoder {
    protected ByteArrayDataOutput output = ByteStreams.newDataOutput();

    public void write(byte[] data) {
        this.output.write(data);
    }

    public void writeByte(byte value) {
        this.output.writeByte((int)value);
    }

    public void writeByte(short value) {
        this.writeByte((byte)value);
    }

    public void writeByte(int value) {
        this.writeByte((byte)value);
    }

    public void writeBoolean(boolean value) {
        this.output.writeBoolean(value);
    }

    public void writeShort(short value) {
        this.output.writeShort((int)value);
    }

    public void writeShort(int value) {
        this.writeShort((short)value);
    }

    public void writeInt(int value) {
        this.output.writeInt(value);
    }

    public void writeLong(long value) {
        this.output.writeLong(value);
    }

    public void writeShortString(String value) {
        this.output.writeShort(value.length());
        this.output.write(value.getBytes(StandardCharsets.UTF_8));
    }

    public void writeString(String value) {
        this.output.writeInt(value.length());
        this.output.write(value.getBytes(StandardCharsets.UTF_8));
    }

    public boolean writeOptional(Object value) {
        boolean hasValue = value != null;
        this.writeBoolean(hasValue);
        return hasValue;
    }

    public void writeObject(Object object) {
        if (object instanceof Encodable) {
            ((Encodable)object).encode(this);
        }
    }

    public <T> void writeCollection(Collection<T> items) {
        this.writeInt(items.size());
        items.forEach(this::writeObject);
    }

    public byte[] toByteArray() {
        return this.output.toByteArray();
    }
}

