/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core;

import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import no.jckf.dhsupport.core.Coordinates;
import no.jckf.dhsupport.core.PerformanceTracker;
import no.jckf.dhsupport.core.PreGenerator;
import no.jckf.dhsupport.core.UpdateChecker;
import no.jckf.dhsupport.core.bytestream.Encoder;
import no.jckf.dhsupport.core.configuration.Configurable;
import no.jckf.dhsupport.core.configuration.Configuration;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import no.jckf.dhsupport.core.database.Database;
import no.jckf.dhsupport.core.database.migrations.CreateLodsTable;
import no.jckf.dhsupport.core.database.models.LodModel;
import no.jckf.dhsupport.core.database.repositories.AsyncLodRepository;
import no.jckf.dhsupport.core.dataobject.Lod;
import no.jckf.dhsupport.core.dataobject.SectionPosition;
import no.jckf.dhsupport.core.handler.LodHandler;
import no.jckf.dhsupport.core.handler.PlayerConfigHandler;
import no.jckf.dhsupport.core.handler.PluginMessageHandler;
import no.jckf.dhsupport.core.lodbuilders.LodBuilder;
import no.jckf.dhsupport.core.message.plugin.FullDataChunkMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataPartialUpdateMessage;
import no.jckf.dhsupport.core.message.plugin.PluginMessageSender;
import no.jckf.dhsupport.core.scheduling.Scheduler;
import no.jckf.dhsupport.core.world.WorldInterface;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class DhSupport
implements Configurable {
    protected String pluginVersion;
    protected String dataDirectory;
    protected Database database;
    protected AsyncLodRepository lodRepository;
    protected Configuration configuration;
    protected Logger logger;
    protected Scheduler scheduler;
    protected UpdateChecker updateChecker;
    @Nullable
    protected CompletableFuture<?> pause;
    protected PerformanceTracker generationTracker = new PerformanceTracker();
    protected Map<UUID, WorldInterface> worldInterfaces = new HashMap<UUID, WorldInterface>();
    protected PluginMessageHandler pluginMessageHandler;
    protected PluginMessageSender pluginMessageSender;
    protected Map<String, CompletableFuture<Lod>> queuedBuilders = new ConcurrentHashMap<String, CompletableFuture<Lod>>();
    protected Map<String, LodModel> touchedLods = new ConcurrentHashMap<String, LodModel>();
    protected Map<UUID, Configuration> playerConfigurations = new HashMap<UUID, Configuration>();
    protected Map<UUID, PreGenerator> preGenerators = new HashMap<UUID, PreGenerator>();

    public DhSupport(String pluginVersion) {
        this.pluginVersion = pluginVersion;
        this.configuration = new Configuration();
        this.database = new Database();
        this.lodRepository = new AsyncLodRepository(this.database);
        this.pluginMessageHandler = new PluginMessageHandler(this);
        this.updateChecker = new UpdateChecker(62013887);
    }

    public void onEnable() {
        this.lodRepository.setLogger(this.getLogger());
        try {
            this.database.open(this.getConfig().getString(DhsConfig.DATABASE_PATH).replace("{datadir}", this.getDataDirectory()));
            this.database.addMigration(CreateLodsTable.class);
            this.database.migrate();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to initialize database!", exception);
        }
        new PlayerConfigHandler(this, this.pluginMessageHandler).register();
        new LodHandler(this, this.pluginMessageHandler).register();
        this.pluginMessageHandler.onEnable();
        if (this.getConfig().getBool(DhsConfig.GENERATE_NEW_CHUNKS, true).booleanValue() && this.getConfig().getBool(DhsConfig.GENERATE_NEW_CHUNKS_WARNING, true).booleanValue()) {
            this.warning("Chunk generation is enabled. New chunks will be generated as needed to complete LOD generation. This could significantly increase the size of your world.");
            this.warning("If you understand what this means and would like to disable this warning, set " + DhsConfig.GENERATE_NEW_CHUNKS_WARNING + " to false in your config.");
        }
        if (this.getConfig().getBool(DhsConfig.CHECK_FOR_UPDATES, true).booleanValue()) {
            this.getScheduler().runOnSeparateThread(() -> {
                this.checkUpdates();
                return null;
            });
        }
    }

    public void onDisable() {
        if (this.pluginMessageHandler != null) {
            this.pluginMessageHandler.onDisable();
        }
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean pause() {
        if (this.pause != null) {
            return false;
        }
        this.pause = new CompletableFuture();
        return true;
    }

    public boolean unpause() {
        if (this.pause == null) {
            return false;
        }
        this.pause.complete(null);
        this.pause = null;
        return true;
    }

    public boolean isPaused() {
        return this.pause != null;
    }

    public void joinPauseState() {
        if (this.pause != null) {
            this.pause.join();
        }
    }

    public PerformanceTracker getGenerationTracker() {
        return this.generationTracker;
    }

    public void setWorldInterface(UUID id, @Nullable WorldInterface worldInterface) {
        if (worldInterface == null) {
            this.worldInterfaces.remove(id);
            return;
        }
        this.worldInterfaces.put(id, worldInterface);
    }

    @Nullable
    public WorldInterface getWorldInterface(UUID id) {
        return this.worldInterfaces.get(id);
    }

    public PluginMessageHandler getPluginMessageHandler() {
        return this.pluginMessageHandler;
    }

    public void setPluginMessageSender(PluginMessageSender sender) {
        this.pluginMessageSender = sender;
    }

    @Nullable
    public PluginMessageSender getPluginMessageSender() {
        return this.pluginMessageSender;
    }

    public AsyncLodRepository getLodRepository() {
        return this.lodRepository;
    }

    @Override
    public Configuration getConfig() {
        return this.configuration;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Nullable
    public Logger getLogger() {
        return this.logger;
    }

    public void info(String message) {
        this.getLogger().info(message);
    }

    public void warning(String message) {
        this.getLogger().warning(message);
    }

    public void debug(String message) {
        if (!this.getConfig().getBool(DhsConfig.DEBUG, false).booleanValue()) {
            return;
        }
        this.getLogger().info("[DEBUG] " + message);
    }

    public void checkUpdates() {
        if (this.updateChecker.isLatestVersion(this.pluginVersion)) {
            return;
        }
        this.warning("A newer version of the plugin is available.");
    }

    public Map<UUID, Configuration> getPlayerConfigurations() {
        return this.playerConfigurations;
    }

    public void setPlayerConfiguration(UUID playerId, Configuration playerConfiguration) {
        this.playerConfigurations.put(playerId, playerConfiguration);
    }

    public Configuration getPlayerConfiguration(UUID playerId) {
        return this.playerConfigurations.get(playerId);
    }

    public void clearPlayerConfiguration(UUID playerId) {
        this.playerConfigurations.remove(playerId);
    }

    public LodBuilder getBuilder(WorldInterface world, SectionPosition position) {
        LodBuilder builder;
        String builderType = world.getConfig().getString(DhsConfig.BUILDER_TYPE);
        try {
            Class<LodBuilder> builderClass = Class.forName(LodBuilder.class.getPackageName() + "." + builderType).asSubclass(LodBuilder.class);
            Constructor<LodBuilder> constructor = builderClass.getConstructor(WorldInterface.class, SectionPosition.class);
            builder = constructor.newInstance(world, position);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            return null;
        }
        return builder;
    }

    public CompletableFuture<Lod> queueBuilder(UUID worldId, SectionPosition position, LodBuilder builder) {
        String key = LodModel.create().setWorldId(worldId).setX(position.getX()).setZ(position.getZ()).toString();
        if (this.queuedBuilders.containsKey(key)) {
            return this.queuedBuilders.get(key);
        }
        CompletionStage queued = ((CompletableFuture)this.getScheduler().runOnSeparateThread(builder::generate).thenApply(lod -> {
            this.queuedBuilders.remove(key);
            return lod;
        })).exceptionally(exception -> {
            exception.printStackTrace();
            this.queuedBuilders.remove(key);
            return null;
        });
        this.queuedBuilders.put(key, (CompletableFuture<Lod>)queued);
        return queued;
    }

    public CompletableFuture<LodModel> getLod(UUID worldId, SectionPosition position) {
        return this.getLodRepository().loadLodAsync(worldId, position.getX(), position.getZ()).thenComposeAsync(modelFromDb -> {
            if (modelFromDb != null) {
                return CompletableFuture.completedFuture(modelFromDb);
            }
            return this.generateLod(worldId, position, true);
        });
    }

    protected CompletableFuture<LodModel> generateLod(UUID worldId, SectionPosition position, boolean manageChunks) {
        this.joinPauseState();
        int worldX = Coordinates.sectionToBlock(position.getX());
        int worldZ = Coordinates.sectionToBlock(position.getZ());
        WorldInterface world = this.getWorldInterface(worldId).newInstance();
        boolean generateNewChunks = world.getConfig().getBool(DhsConfig.GENERATE_NEW_CHUNKS, true);
        HashMap<CallSite, CompletableFuture<Boolean>> loads = new HashMap<CallSite, CompletableFuture<Boolean>>();
        if (manageChunks) {
            for (int xMultiplier = 0; xMultiplier < 4; ++xMultiplier) {
                for (int zMultiplier = 0; zMultiplier < 4; ++zMultiplier) {
                    int chunkX = worldX + 16 * xMultiplier;
                    int chunkZ = worldZ + 16 * zMultiplier;
                    if (world.isChunkLoaded(chunkX, chunkZ)) continue;
                    if (generateNewChunks) {
                        loads.put((CallSite)((Object)(worldX + "x" + worldZ)), world.loadOrGenerateChunkAsync(chunkX, chunkZ));
                        continue;
                    }
                    loads.put((CallSite)((Object)(worldX + "x" + worldZ)), world.loadChunkAsync(chunkX, chunkZ));
                }
            }
        }
        return CompletableFuture.allOf(loads.values().toArray(new CompletableFuture[0])).thenComposeAsync(asd -> {
            boolean loadRejected = loads.values().stream().map(loadRequest -> {
                try {
                    return (Boolean)loadRequest.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    return false;
                }
            }).anyMatch(Predicate.isEqual(false));
            if (loadRejected) {
                this.getScheduler().runOnRegionThread(worldId, worldX, worldZ, () -> {
                    for (String key : loads.keySet()) {
                        String[] xz = key.split("x", 2);
                        world.discardChunk(Integer.parseInt(xz[0]), Integer.parseInt(xz[1]));
                    }
                    return null;
                });
                if (world.getConfig().getStringList(DhsConfig.DUMMY_CHUNK).isEmpty()) {
                    return CompletableFuture.completedFuture(null);
                }
                world.setDummyMode(true);
            }
            CompletableFuture<Lod> lodFuture = this.queueBuilder(worldId, position, this.getBuilder(world, position));
            return ((CompletableFuture)lodFuture.thenApply(lod -> {
                this.getScheduler().runOnRegionThread(worldId, worldX, worldZ, () -> {
                    for (String key : loads.keySet()) {
                        String[] xz = key.split("x", 2);
                        world.discardChunk(Integer.parseInt(xz[0]), Integer.parseInt(xz[1]));
                    }
                    return null;
                });
                Encoder lodEncoder = new Encoder();
                lod.encode(lodEncoder);
                Encoder beaconEncoder = new Encoder();
                beaconEncoder.writeCollection(lod.getBeacons());
                this.generationTracker.ping();
                return this.lodRepository.saveLodAsync(worldId, position.getX(), position.getZ(), lodEncoder.toByteArray(), beaconEncoder.toByteArray());
            })).thenCompose(f -> f);
        });
    }

    public void touchLod(UUID worldId, int x, int z, @Nullable String reason) {
        int sectionX = Coordinates.blockToSection(x);
        int sectionZ = Coordinates.blockToSection(z);
        LodModel lodModel = LodModel.create().setWorldId(worldId).setX(sectionX).setZ(sectionZ);
        String key = lodModel.toString();
        if (this.touchedLods.containsKey(key)) {
            return;
        }
        this.debug("Touched LOD at " + this.getWorldInterface(worldId).getName() + " " + x + " " + z + (String)(reason == null ? "." : ": " + reason));
        this.touchedLods.put(key, lodModel);
    }

    public void touchLod(UUID worldId, int x, int z) {
        this.touchLod(worldId, x, z, null);
    }

    public void updateTouchedLods() {
        if (this.isPaused()) {
            return;
        }
        for (String key : this.touchedLods.keySet()) {
            LodModel lodModelToDelete = this.touchedLods.get(key);
            this.touchedLods.remove(key);
            WorldInterface world = this.getWorldInterface(lodModelToDelete.getWorldId());
            this.debug("Changes detected in " + world.getName() + " " + lodModelToDelete.getX() + " " + lodModelToDelete.getZ() + ".");
            this.getLodRepository().lodExistsAsync(lodModelToDelete.getWorldId(), lodModelToDelete.getX(), lodModelToDelete.getZ()).thenAccept(exists -> {
                if (!exists.booleanValue()) {
                    return;
                }
                this.getLodRepository().deleteLodAsync(lodModelToDelete.getWorldId(), lodModelToDelete.getX(), lodModelToDelete.getZ()).thenAccept(deleted -> {
                    if (!deleted.booleanValue()) {
                        this.warning("Could not delete LOD " + world.getName() + " " + lodModelToDelete.getX() + " " + lodModelToDelete.getZ() + ".");
                        return;
                    }
                    SectionPosition position = new SectionPosition();
                    position.setDetailLevel(6);
                    position.setX(lodModelToDelete.getX());
                    position.setZ(lodModelToDelete.getZ());
                    this.getLod(lodModelToDelete.getWorldId(), position).thenAcceptAsync(newLodModel -> {
                        Configuration worldConfig = world.getConfig();
                        boolean updatesEnabled = worldConfig.getBool(DhsConfig.REAL_TIME_UPDATES_ENABLED);
                        if (!updatesEnabled) {
                            this.debug("New LOD " + world.getName() + " " + lodModelToDelete.getX() + " " + lodModelToDelete.getZ() + " generated, but real-time updates are disabled.");
                            return;
                        }
                        String levelKeyPrefix = worldConfig.getString(DhsConfig.LEVEL_KEY_PREFIX);
                        Object levelKey = world.getKey();
                        if (levelKeyPrefix != null) {
                            levelKey = levelKeyPrefix + (String)levelKey;
                        }
                        int lodChunkX = Coordinates.sectionToChunk(lodModelToDelete.getX());
                        int lodChunkZ = Coordinates.sectionToChunk(lodModelToDelete.getZ());
                        int playersInRangeCount = 0;
                        int playersOutOfRangeCount = 0;
                        int playersWithoutDhCount = 0;
                        for (Player player : Bukkit.getWorld((UUID)newLodModel.getWorldId()).getPlayers()) {
                            Configuration playerConfig = this.getPlayerConfiguration(player.getUniqueId());
                            if (playerConfig == null) {
                                ++playersWithoutDhCount;
                                continue;
                            }
                            if (!playerConfig.getBool(DhsConfig.DISTANT_GENERATION_ENABLED).booleanValue() || !playerConfig.getBool(DhsConfig.REAL_TIME_UPDATES_ENABLED).booleanValue()) continue;
                            int updatesRadius = playerConfig.getInt(DhsConfig.REAL_TIME_UPDATE_RADIUS);
                            int playerChunkX = Coordinates.blockToChunk(player.getLocation().getBlockX());
                            int playerChunkZ = Coordinates.blockToChunk(player.getLocation().getBlockZ());
                            int distanceX = Math.abs(Math.max(lodChunkX, playerChunkX) - Math.min(lodChunkX, playerChunkX));
                            int distanceZ = Math.abs(Math.max(lodChunkZ, playerChunkZ) - Math.min(lodChunkZ, playerChunkZ));
                            if (distanceX > updatesRadius || distanceZ > updatesRadius) {
                                ++playersOutOfRangeCount;
                                continue;
                            }
                            ++playersInRangeCount;
                            int myBufferId = playerConfig.increment("buffer-id");
                            FullDataPartialUpdateMessage partialUpdateMessage = new FullDataPartialUpdateMessage();
                            partialUpdateMessage.setLevelKey((String)levelKey);
                            partialUpdateMessage.setBufferId(myBufferId);
                            partialUpdateMessage.setBeacons(newLodModel.getBeacons());
                            byte[] data = newLodModel.getData();
                            int chunkCount = (int)Math.ceil((double)data.length / (double)LodHandler.CHUNK_SIZE);
                            for (int chunkNo = 0; chunkNo < chunkCount; ++chunkNo) {
                                FullDataChunkMessage chunkResponse = new FullDataChunkMessage();
                                chunkResponse.setBufferId(myBufferId);
                                chunkResponse.setIsFirst(chunkNo == 0);
                                chunkResponse.setData(Arrays.copyOfRange(data, LodHandler.CHUNK_SIZE * chunkNo, Math.min(LodHandler.CHUNK_SIZE * chunkNo + LodHandler.CHUNK_SIZE, data.length)));
                                this.pluginMessageHandler.sendPluginMessage(player.getUniqueId(), chunkResponse);
                            }
                            this.pluginMessageHandler.sendPluginMessage(player.getUniqueId(), partialUpdateMessage);
                        }
                        this.debug("Updated LOD " + world.getName() + " " + lodModelToDelete.getX() + " " + lodModelToDelete.getZ() + " sent to " + playersInRangeCount + " players. Found " + playersOutOfRangeCount + " players out of range, and " + playersWithoutDhCount + " players without DH.");
                    });
                });
            });
        }
    }

    public boolean isPreGenerating(WorldInterface world) {
        return this.preGenerators.containsKey(world.getId()) && this.getPreGenerator(world).isRunning();
    }

    public void preGenerate(WorldInterface world, int centerX, int centerZ, int radius, boolean force) {
        if (this.isPreGenerating(world)) {
            this.info("Cannot run multiple pre-generators in the same world. Stopping current task for " + world.getName() + "...");
            this.stopPreGenerator(world);
        }
        this.preGenerators.put(world.getId(), new PreGenerator(this, world, centerX, centerZ, radius, force));
        this.getScheduler().runOnSeparateThread(() -> {
            this.preGenerators.get(world.getId()).run();
            return null;
        });
    }

    @Nullable
    public PreGenerator getPreGenerator(WorldInterface world) {
        return this.preGenerators.get(world.getId());
    }

    public void stopPreGenerator(WorldInterface world) {
        if (this.isPreGenerating(world)) {
            this.getPreGenerator(world).stop();
            this.preGenerators.remove(world.getId());
        }
    }

    public CompletableFuture<Integer> trim(WorldInterface world, int centerX, int centerZ, int radius) {
        return this.getLodRepository().trimLodsAsync(world.getId(), Coordinates.blockToSection(centerX - radius), Coordinates.blockToSection(centerZ - radius), Coordinates.blockToSection(centerX + radius), Coordinates.blockToSection(centerZ + radius));
    }

    public CompletableFuture<Double> benchmark(UUID worldId, int iterations, int concurrency) {
        WorldInterface world = this.getWorldInterface(worldId);
        ArrayList<SectionPosition> positions = new ArrayList<SectionPosition>();
        for (int i = 0; i < concurrency; ++i) {
            SectionPosition position2 = new SectionPosition();
            position2.setX(Coordinates.blockToSection(world.getSpawnX()) + i);
            position2.setZ(Coordinates.blockToSection(world.getSpawnZ()));
            positions.add(position2);
        }
        return CompletableFuture.allOf((CompletableFuture[])positions.stream().map(position -> this.generateLod(world.getId(), (SectionPosition)position, false)).toArray(CompletableFuture[]::new)).thenCompose(foo -> {
            ArrayList<CompletableFuture<Object>> chains = new ArrayList<CompletableFuture<Object>>();
            long ts = System.currentTimeMillis();
            for (SectionPosition position : positions) {
                CompletionStage<Object> chain = CompletableFuture.completedFuture(null);
                for (int i = 0; i < iterations; ++i) {
                    chain = chain.thenCompose(bar -> this.generateLod(world.getId(), position, false));
                }
                chains.add((CompletableFuture<Object>)chain);
            }
            return CompletableFuture.allOf((CompletableFuture[])chains.toArray(CompletableFuture[]::new)).thenApply(bar -> {
                double elapsed = (double)(System.currentTimeMillis() - ts) / 1000.0;
                return (double)(iterations * concurrency) / elapsed;
            });
        });
    }
}

