package com.coloryr.allmusic.client;

import com.coloryr.allmusic.client.core.AllMusicBridge;
import com.coloryr.allmusic.client.core.AllMusicCore;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_10868;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.client.render.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix3x2fStack;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class AllMusic implements ClientModInitializer, AllMusicBridge {
    public static final class_2960 ID = class_2960.method_60655("allmusic", "channel");

    private static class_332 context;

    public static final Logger LOGGER = LogManager.getLogger("AllMusic Client");

    public static class Tex extends class_1044 {
        public Tex(GpuTexture tex, GpuTextureView view) {
            this.field_56974 = tex;
            this.field_60597 = view;
        }
    }

    public Object genTexture(int size) {
        var device = RenderSystem.getDevice();
        var tex = device.createTexture("allmusic:gui_textured", 5, TextureFormat.RGBA8, size, size, 1, 1);
        tex.setTextureFilter(FilterMode.NEAREST, false);

        var view = device.createTextureView(tex);

        Tex tex1 = new Tex(tex, view);

        class_310.method_1551().method_1531().method_4616(ID, tex1);

        return tex;
    }

    public void updateTexture(Object tex, int size, ByteBuffer byteBuffer) {
        if (tex instanceof class_10868 tex1) {
            AllMusicCore.updateGLTexture(tex1.method_68427(), size, byteBuffer);
        }
    }

    public int getScreenWidth() {
        return class_310.method_1551().method_22683().method_4486();
    }

    public int getScreenHeight() {
        return class_310.method_1551().method_22683().method_4502();
    }

    public int getTextWidth(String item) {
        return class_310.method_1551().field_1772.method_1727(item);
    }

    public int getFontHeight() {
        return class_310.method_1551().field_1772.field_2000;
    }

    public void drawText(String item, int x, int y, int color, boolean shadow) {
        var hud = class_310.method_1551().field_1772;
        context.method_51433(hud, item, x, y, color, shadow);
    }

    public void drawPic(Object texture, int size, int x, int y, int ang) {
        Matrix3x2fStack stack = context.method_51448();
        Matrix3x2fStack matrix = stack.pushMatrix();

        int a = size / 2;

        if (ang > 0) {
            matrix.translation(x + a, y + a);
            matrix.pushMatrix().rotate((float) Math.toRadians(ang));
        } else {
            matrix.translation(x + a, y + a);
        }

        context.method_25302(class_10799.field_56883, ID, -a, -a, 0, 0, size, size, size, size, size, size);
        stack.popMatrix();
        if (ang > 0) {
            stack.popMatrix();
        }
    }

    public void sendMessage(String data) {
        data = "[AllMusic Client]" + data;
        LOGGER.warn(data);
        String finalData = data;
        class_310.method_1551().execute(() -> {
            if (class_310.method_1551().field_1724 == null)
                return;
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163(finalData), false);
        });
    }

    public float getVolume() {
        return class_310.method_1551().field_1690.method_71978(class_3419.field_15247);
    }

    @Override
    public void stopPlayMusic() {
        class_310.method_1551().method_1483().method_4875(null, class_3419.field_15253);
        class_310.method_1551().method_1483().method_4875(null, class_3419.field_15247);
    }

    public static void update(class_332 draw) {
        context = draw;
        AllMusicCore.hudUpdate();
    }

    private static String readString(class_2540 buf) {
        int size = buf.readInt();
        byte[] temp = new byte[size];
        buf.method_52979(temp);

        return new String(temp, StandardCharsets.UTF_8);
    }

    public record PackPayload() implements class_8710 {
        public static final class_9154<PackPayload> ID = new class_8710.class_9154<>(AllMusic.ID);
        public static final class_9139<class_2540, PackPayload> CODEC = class_9139.method_56438((value, buf) -> {
        }, buffer -> {
            AllMusicCore.packRead(buffer);
            return new PackPayload();
        });

        @Override
        public class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    @Override
    public void onInitializeClient() {
        PayloadTypeRegistry.playS2C().register(PackPayload.ID, PackPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(PackPayload.ID, (pack, handler) -> {

        });

        AllMusicCore.init(FabricLoader.getInstance().getConfigDir(), this);
    }
}
