/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.client.core.player.decoder.flac;

import com.coloryr.allmusic.client.core.AllMusicCore;
import com.coloryr.allmusic.client.core.player.AllMusicPlayer;
import com.coloryr.allmusic.client.core.player.decoder.BuffPack;
import com.coloryr.allmusic.client.core.player.decoder.IDecoder;
import com.coloryr.allmusic.client.core.player.decoder.flac.DataFormatException;
import com.coloryr.allmusic.client.core.player.decoder.flac.FlacLowLevelInput;
import com.coloryr.allmusic.client.core.player.decoder.flac.FrameDecoder;
import com.coloryr.allmusic.client.core.player.decoder.flac.FrameInfo;
import com.coloryr.allmusic.client.core.player.decoder.flac.SeekTable;
import com.coloryr.allmusic.client.core.player.decoder.flac.SeekableFileFlacInput;
import com.coloryr.allmusic.client.core.player.decoder.flac.StreamInfo;
import java.io.IOException;

public final class FlacDecoder
implements AutoCloseable,
IDecoder {
    private final AllMusicPlayer player;
    private final BuffPack pack = new BuffPack();
    public StreamInfo streamInfo;
    public SeekTable seekTable;
    private FlacLowLevelInput input;
    private long metadataEndPos;
    private FrameDecoder frameDec;
    private int[][] samples;
    private byte[] sampleBytes;

    public FlacDecoder(AllMusicPlayer player) {
        this.player = player;
    }

    public Object[] readAndHandleMetadataBlock() throws IOException {
        if (this.metadataEndPos != -1L) {
            return null;
        }
        boolean last = this.input.readUint(1) != 0;
        int type = this.input.readUint(7);
        int length = this.input.readUint(24);
        byte[] data = new byte[length];
        this.input.readFully(data);
        if (type == 0) {
            if (this.streamInfo != null) {
                throw new DataFormatException("Duplicate stream info metadata block");
            }
            this.streamInfo = new StreamInfo(data);
        } else {
            if (this.streamInfo == null) {
                throw new DataFormatException("Expected stream info metadata block");
            }
            if (type == 3) {
                if (this.seekTable != null) {
                    throw new DataFormatException("Duplicate seek table metadata block");
                }
                this.seekTable = new SeekTable(data);
            }
        }
        if (last) {
            this.metadataEndPos = this.input.getPosition();
            this.frameDec = new FrameDecoder(this.input, this.streamInfo.sampleDepth);
        }
        return new Object[]{type, data};
    }

    public int readAudioBlock(int[][] samples, int off) throws IOException {
        if (this.frameDec == null) {
            throw new IllegalStateException("Metadata blocks not fully consumed yet");
        }
        FrameInfo frame = this.frameDec.readFrame(samples, off);
        if (frame == null) {
            return 0;
        }
        return frame.blockSize;
    }

    @Override
    public BuffPack decodeFrame() throws Exception {
        int blockSamples = this.readAudioBlock(this.samples, 0);
        int sampleBytesLen = 0;
        for (int i = 0; i < blockSamples; ++i) {
            for (int ch = 0; ch < this.streamInfo.numChannels; ++ch) {
                int val = this.samples[ch][i];
                if (this.streamInfo.sampleDepth == 24) {
                    float temp = (float)val / 1.6777216E7f;
                    val = (int)(temp * 32767.0f);
                } else if (this.streamInfo.sampleDepth == 32) {
                    float temp = (float)val / 1.0995116E12f;
                    val = (int)(temp * 32767.0f);
                }
                int j = 0;
                while (j < 2) {
                    this.sampleBytes[sampleBytesLen] = (byte)(val >>> (j << 3));
                    ++j;
                    ++sampleBytesLen;
                }
            }
        }
        this.pack.len = sampleBytesLen;
        this.pack.buff = this.sampleBytes;
        return this.pack;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.streamInfo = null;
            this.seekTable = null;
            this.frameDec = null;
            this.input.close();
            this.input = null;
        }
    }

    @Override
    public boolean set() throws Exception {
        this.input = new SeekableFileFlacInput(this.player);
        if (this.input.readUint(32) != 1716281667) {
            return false;
        }
        this.metadataEndPos = -1L;
        while (this.readAndHandleMetadataBlock() != null) {
        }
        int bytesPerSample = this.streamInfo.sampleDepth / 8;
        this.samples = new int[this.streamInfo.numChannels][65536];
        this.sampleBytes = new byte[65536 * this.streamInfo.numChannels * bytesPerSample];
        return true;
    }

    @Override
    public int getOutputFrequency() {
        return this.streamInfo.sampleRate;
    }

    @Override
    public int getOutputChannels() {
        return this.streamInfo.numChannels;
    }

    @Override
    public void set(int time) {
        AllMusicCore.bridge.sendMessage("\u4e0d\u652f\u6301\u4e2d\u95f4\u64ad\u653e");
    }
}

