/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.client.core.hud;

import com.coloryr.allmusic.client.core.AllMusicCore;
import com.coloryr.allmusic.client.core.hud.HudDirType;
import com.coloryr.allmusic.client.core.objs.SaveOBJ;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class AllMusicHud {
    private final Queue<String> urlList = new ConcurrentLinkedDeque<String>();
    private final Semaphore semaphore = new Semaphore(0);
    private final HttpClient client;
    private final ByteBuffer byteBuffer;
    public String info = "";
    public String list = "";
    public String lyric = "";
    public SaveOBJ save;
    private boolean haveImg;
    private boolean thisRoute;
    private HttpGet get;
    private InputStream inputStream;
    private int ang = 0;
    private int count = 0;
    private boolean display;
    private boolean needUpload;
    private final Object texture;
    private final int size;

    public AllMusicHud(int size) {
        this.size = size;
        Thread thread = new Thread(this::run);
        thread.setName("allmusic_pic");
        thread.start();
        this.client = HttpClientBuilder.create().useSystemProperties().build();
        this.byteBuffer = ByteBuffer.allocateDirect(size * size * 4);
        this.texture = AllMusicCore.bridge.genTexture(size);
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(this::picRotateTick, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    private void picRotateTick() {
        if (this.save == null) {
            return;
        }
        if (this.count < this.save.picRotateSpeed) {
            ++this.count;
            return;
        }
        this.count = 0;
        ++this.ang;
        this.ang %= 360;
    }

    public void close() {
        this.haveImg = false;
        this.lyric = "";
        this.list = "";
        this.info = "";
        this.getClose();
    }

    private void getClose() {
        try {
            if (this.get != null && !this.get.isAborted()) {
                this.get.abort();
                this.get = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPic(String picUrl) {
        this.haveImg = false;
        try {
            this.getClose();
            while (this.save == null || this.needUpload) {
                Thread.sleep(200L);
            }
            if (!this.save.pic.enable) {
                return;
            }
            this.get = new HttpGet(picUrl);
            HttpResponse response = this.client.execute((HttpUriRequest)this.get);
            HttpEntity entity = response.getEntity();
            this.inputStream = entity.getContent();
            BufferedImage image = AllMusicHud.resizeImage(ImageIO.read(this.inputStream), this.size, this.size);
            int[] pixels = new int[this.size * this.size];
            if (this.save.pic.shadow) {
                BufferedImage formatAvatarImage = new BufferedImage(this.size, this.size, 2);
                Graphics2D graphics = formatAvatarImage.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int border = (int)((double)this.size * 0.11);
                Ellipse2D.Double shape = new Ellipse2D.Double(border, border, this.size - border * 2, this.size - border * 2);
                graphics.setClip(shape);
                graphics.drawImage(image, border, border, this.size - border * 2, this.size - border * 2, null);
                graphics.dispose();
                graphics = formatAvatarImage.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int border1 = (int)((double)this.size * 0.08);
                BasicStroke s = new BasicStroke(border1, 1, 1);
                graphics.setStroke(s);
                graphics.setColor(Color.decode("#121212"));
                graphics.drawOval(border1, border1, this.size - border1 * 2, this.size - border1 * 2);
                border1 = (int)((double)this.size * 0.05);
                float si = border1 / 6;
                s = new BasicStroke(si, 1, 1);
                graphics.setStroke(s);
                graphics.setColor(Color.decode("#181818"));
                graphics.drawOval(border1, border1, this.size - border1 * 2, this.size - border1 * 2);
                border1 = (int)((double)this.size * 0.065);
                graphics.drawOval(border1, border1, this.size - border1 * 2, this.size - border1 * 2);
                border1 = (int)((double)this.size * 0.08);
                graphics.drawOval(border1, border1, this.size - border1 * 2, this.size - border1 * 2);
                border1 = (int)((double)this.size * 0.095);
                graphics.drawOval(border1, border1, this.size - border1 * 2, this.size - border1 * 2);
                graphics.dispose();
                formatAvatarImage.getRGB(0, 0, this.size, this.size, pixels, 0, this.size);
                this.getClose();
                this.thisRoute = true;
            } else {
                image.getRGB(0, 0, this.size, this.size, pixels, 0, this.size);
                this.getClose();
                this.thisRoute = false;
            }
            ByteBuffer byteBuffer = this.byteBuffer;
            synchronized (byteBuffer) {
                for (int h = 0; h < this.size; ++h) {
                    for (int w = 0; w < this.size; ++w) {
                        int pixel = pixels[h * this.size + w];
                        this.byteBuffer.put((byte)(pixel >> 16 & 0xFF));
                        this.byteBuffer.put((byte)(pixel >> 8 & 0xFF));
                        this.byteBuffer.put((byte)(pixel & 0xFF));
                        this.byteBuffer.put((byte)(pixel >> 24 & 0xFF));
                    }
                }
                this.byteBuffer.flip();
            }
            this.needUpload = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            AllMusicCore.bridge.sendMessage("\u56fe\u7247\u89e3\u6790\u9519\u8bef");
            this.haveImg = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexture() {
        ByteBuffer byteBuffer = this.byteBuffer;
        synchronized (byteBuffer) {
            AllMusicCore.bridge.updateTexture(this.texture, this.size, this.byteBuffer);
        }
        this.haveImg = true;
    }

    private void run() {
        while (true) {
            try {
                block3: while (true) {
                    this.semaphore.acquire();
                    while (true) {
                        if (this.urlList.isEmpty()) continue block3;
                        String picUrl = this.urlList.poll();
                        if (picUrl == null) continue;
                        this.loadPic(picUrl);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setImg(String picUrl) {
        this.urlList.add(picUrl);
        this.semaphore.release();
    }

    public void setPos(SaveOBJ save) {
        this.save = save;
    }

    public void update() {
        SaveOBJ save = this.save;
        if (save == null) {
            return;
        }
        if (save.info.enable && !this.info.isEmpty()) {
            String[] temp;
            int offset = 0;
            for (String item : temp = this.info.split("\n")) {
                this.drawText(item, save.info.x, save.info.y + offset, save.info.dir, save.info.color, save.info.shadow);
                offset += 10;
            }
        }
        if (save.list.enable && !this.list.isEmpty()) {
            String[] temp = this.list.split("\n");
            int offset = 0;
            for (String item : temp) {
                this.drawText(item, save.list.x, save.list.y + offset, save.list.dir, save.list.color, save.list.shadow);
                offset += 10;
            }
        }
        if (save.lyric.enable && !this.lyric.isEmpty()) {
            String[] temp = this.lyric.split("\n");
            int offset = 0;
            for (String item : temp) {
                this.drawText(item, save.lyric.x, save.lyric.y + offset, save.lyric.dir, save.lyric.color, save.lyric.shadow);
                offset += 10;
            }
        }
        if (this.needUpload) {
            this.needUpload = false;
            if (this.display) {
                this.display = false;
                this.needUpload = true;
                return;
            }
            this.updateTexture();
        }
        if (save.pic.enable && this.haveImg) {
            this.display = true;
            this.drawPic(save.pic.color, save.pic.x, save.pic.y, save.pic.dir, this.ang);
            this.display = false;
        }
    }

    private void drawPic(int size, int x, int y, HudDirType dir, int ang) {
        if (dir == null) {
            return;
        }
        int screenWidth = AllMusicCore.bridge.getScreenWidth();
        int screenHeight = AllMusicCore.bridge.getScreenHeight();
        int x1 = x;
        int y1 = y;
        switch (dir) {
            case TOP_CENTER: {
                x1 = screenWidth / 2 - size / 2 + x;
                break;
            }
            case TOP_RIGHT: {
                x1 = screenWidth - size - x;
                break;
            }
            case LEFT: {
                y1 = screenHeight / 2 - size / 2 + y;
                break;
            }
            case CENTER: {
                x1 = screenWidth / 2 - size / 2 + x;
                y1 = screenHeight / 2 - size / 2 + y;
                break;
            }
            case RIGHT: {
                x1 = screenWidth - size - x;
                y1 = screenHeight / 2 - size / 2 + y;
                break;
            }
            case BOTTOM_LEFT: {
                y1 = screenHeight - size - y;
                break;
            }
            case BOTTOM_CENTER: {
                x1 = screenWidth / 2 - size / 2 + x;
                y1 = screenHeight - size - y;
                break;
            }
            case BOTTOM_RIGHT: {
                x1 = screenWidth - size - x;
                y1 = screenHeight - size - y;
            }
        }
        AllMusicCore.bridge.drawPic(this.texture, size, x1, y1, this.save.pic.shadow && this.thisRoute ? ang : 0);
    }

    private void drawText(String item, int x, int y, HudDirType dir, int color, boolean shadow) {
        int width = AllMusicCore.bridge.getTextWidth(item);
        int height = AllMusicCore.bridge.getFontHeight();
        int screenWidth = AllMusicCore.bridge.getScreenWidth();
        int screenHeight = AllMusicCore.bridge.getScreenHeight();
        int x1 = x;
        int y1 = y;
        switch (dir) {
            case TOP_CENTER: {
                x1 = screenWidth / 2 - width / 2 + x;
                break;
            }
            case TOP_RIGHT: {
                x1 = screenWidth - width - x;
                break;
            }
            case LEFT: {
                y1 = screenHeight / 2 - height / 2 + y;
                break;
            }
            case CENTER: {
                x1 = screenWidth / 2 - width / 2 + x;
                y1 = screenHeight / 2 - height / 2 + y;
                break;
            }
            case RIGHT: {
                x1 = screenWidth - width - x;
                y1 = screenHeight / 2 - height / 2 + y;
                break;
            }
            case BOTTOM_LEFT: {
                y1 = screenHeight - height - y;
                break;
            }
            case BOTTOM_CENTER: {
                x1 = screenWidth / 2 - width / 2 + x;
                y1 = screenHeight - height - y;
                break;
            }
            case BOTTOM_RIGHT: {
                x1 = screenWidth - width - x;
                y1 = screenHeight - height - y;
            }
        }
        AllMusicCore.bridge.drawText(item, x1, y1, color, shadow);
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, 16);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 2);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }
}

