/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.client.core;

import com.coloryr.allmusic.client.core.AllMusicBridge;
import com.coloryr.allmusic.client.core.CommandType;
import com.coloryr.allmusic.client.core.hud.AllMusicHud;
import com.coloryr.allmusic.client.core.objs.ConfigObj;
import com.coloryr.allmusic.client.core.objs.SaveOBJ;
import com.coloryr.allmusic.client.core.player.AllMusicPlayer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.lwjgl.opengl.GL11;

public class AllMusicCore {
    public static final CommandType[] types = CommandType.values();
    private static final Gson gson = new Gson();
    private static AllMusicPlayer player;
    private static AllMusicHud hud;
    public static AllMusicBridge bridge;
    public static ConfigObj config;

    public static void tick() {
        if (player != null) {
            player.tick();
        }
    }

    public static boolean isPlay() {
        if (player == null) {
            return false;
        }
        return player.isPlay();
    }

    public static void init(Path file, AllMusicBridge bridge, IntBuffer source) {
        File configFile = new File(file.toFile(), "allmusic_client.json");
        if (configFile.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
                BufferedReader bf = new BufferedReader(reader);
                config = (ConfigObj)new Gson().fromJson((Reader)bf, ConfigObj.class);
                bf.close();
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (config == null) {
            config = new ConfigObj();
            AllMusicCore.config.picSize = 200;
            AllMusicCore.config.queueSize = 100;
            AllMusicCore.config.exitSize = 50;
            try {
                String data = new GsonBuilder().setPrettyPrinting().create().toJson((Object)config);
                FileOutputStream out = new FileOutputStream(configFile);
                OutputStreamWriter write = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                write.write(data);
                write.close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AllMusicCore.bridge = bridge;
        player = new AllMusicPlayer(source);
    }

    public static void init(Path file, AllMusicBridge bridge) {
        AllMusicCore.init(file, bridge, null);
    }

    public static void glInit() {
        hud = new AllMusicHud(AllMusicCore.config.picSize);
    }

    public static void onServerQuit() {
        try {
            AllMusicCore.stopPlaying();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AllMusicCore.hud.save = null;
    }

    private static void stopPlaying() {
        player.closePlayer();
        hud.close();
    }

    public static void reload() {
        if (player != null) {
            player.setReload();
        }
    }

    public static void hudUpdate() {
        hud.update();
    }

    private static String readString(ByteBuf buf) {
        int size = buf.readInt();
        byte[] temp = new byte[size];
        buf.readBytes(temp);
        return new String(temp, StandardCharsets.UTF_8);
    }

    public static void packRead(ByteBuf buffer) {
        byte type = buffer.readByte();
        if (type >= types.length || type < 0) {
            return;
        }
        CommandType type1 = types[type];
        String data = null;
        int data1 = 0;
        switch (type1) {
            case LYRIC: 
            case INFO: 
            case LIST: 
            case PLAY: 
            case IMG: 
            case HUD_DATA: {
                data = AllMusicCore.readString(buffer);
                break;
            }
            case POS: {
                data1 = buffer.readInt();
            }
        }
        AllMusicCore.packDo(type1, data, data1);
        buffer.clear();
    }

    public static void packDo(CommandType type, String data, int data1) {
        if (type == CommandType.PLAY) {
            bridge.stopPlayMusic();
        }
        switch (type) {
            case LYRIC: {
                AllMusicCore.hud.lyric = data;
                break;
            }
            case INFO: {
                AllMusicCore.hud.info = data;
                break;
            }
            case LIST: {
                AllMusicCore.hud.list = data;
                break;
            }
            case PLAY: {
                AllMusicCore.stopPlaying();
                player.setMusic(data);
                break;
            }
            case IMG: {
                hud.setImg(data);
                break;
            }
            case STOP: {
                AllMusicCore.stopPlaying();
                break;
            }
            case CLEAR: {
                hud.close();
                break;
            }
            case POS: {
                player.set(data1);
                break;
            }
            case HUD_DATA: {
                hud.setPos((SaveOBJ)gson.fromJson(data, SaveOBJ.class));
            }
        }
    }

    public static int genGLTexture(int size) {
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)size, (int)size, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        GL11.glBindTexture((int)3553, (int)0);
        return textureID;
    }

    public static void updateGLTexture(int id, int size, ByteBuffer byteBuffer) {
        GL11.glBindTexture((int)3553, (int)id);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)size, (int)size, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
        GL11.glBindTexture((int)3553, (int)0);
    }
}

