/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.event;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.interfaces.IWorldLoadListener;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.CachedTagManager;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.data.DataManager;
import fi.dy.masa.tweakeroo.data.EntityDataManager;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;

public class WorldLoadListener
implements IWorldLoadListener {
    public void onWorldLoadImmutable(class_5455.class_6890 immutable) {
        RenderTweaks.setDynamicRegistryManager(immutable);
    }

    public void onWorldLoadPre(@Nullable class_638 worldBefore, @Nullable class_638 worldAfter, class_310 mc) {
        FeatureToggle.TWEAK_FREE_CAMERA.setBooleanValue(false);
        if (worldBefore != null && worldAfter == null) {
            this.writeDataGlobal();
        }
        if (worldAfter != null) {
            EntityDataManager.getInstance().onWorldPre();
        }
    }

    public void onWorldLoadPost(@Nullable class_638 worldBefore, @Nullable class_638 worldAfter, class_310 mc) {
        DataManager.getInstance().reset(worldAfter == null);
        EntityDataManager.getInstance().reset(worldAfter == null);
        if (worldBefore == null) {
            if (FeatureToggle.TWEAK_GAMMA_OVERRIDE.getBooleanValue()) {
                FeatureToggle.TWEAK_GAMMA_OVERRIDE.setBooleanValue(false);
                MiscUtils.toggleGammaOverrideWithMessage();
            }
            if (FeatureToggle.TWEAK_DARKNESS_VISIBILITY.getBooleanValue() && ((Double)mc.field_1690.method_42472().method_41753()).doubleValue() != Configs.Generic.DARKNESS_SCALE_OVERRIDE_VALUE.getDoubleValue()) {
                Configs.Internal.DARKNESS_SCALE_VALUE_ORIGINAL.setDoubleValue(((Double)mc.field_1690.method_42472().method_41753()).doubleValue());
                mc.field_1690.method_42472().method_41748((Object)Configs.Generic.DARKNESS_SCALE_OVERRIDE_VALUE.getDoubleValue());
            }
        }
        if (worldAfter != null) {
            if (worldBefore == null) {
                this.readStoredDataGlobal();
            }
            EntityDataManager.getInstance().onWorldJoin();
            CachedTagManager.startCache();
        } else {
            Configs.Internal.SHULKER_MAX_STACK_SIZE.resetToDefault();
        }
    }

    private void writeDataGlobal() {
        Path file = WorldLoadListener.getCurrentStorageFile(true);
        JsonObject root = new JsonObject();
        boolean shouldSave = false;
        if (Files.exists(file, new LinkOption[0])) {
            FileUtils.delete((Path)file);
        }
        if (!CameraPresetManager.getInstance().isEmpty()) {
            root.add("camera_presets", CameraPresetManager.getInstance().toJson());
            shouldSave = true;
        }
        if (shouldSave) {
            JsonUtils.writeJsonToFileAsPath((JsonObject)root, (Path)file);
        }
    }

    private void readStoredDataGlobal() {
        JsonObject root;
        Path file = WorldLoadListener.getCurrentStorageFile(true);
        JsonElement element = JsonUtils.parseJsonFileAsPath((Path)file);
        if (element != null && element.isJsonObject() && JsonUtils.hasObject((JsonObject)(root = element.getAsJsonObject()), (String)"camera_presets")) {
            CameraPresetManager.getInstance().fromJson((JsonElement)JsonUtils.getNestedObject((JsonObject)root, (String)"camera_presets", (boolean)false));
        }
    }

    public static Path getCurrentConfigDirectory() {
        return FileUtils.getConfigDirectoryAsPath().resolve("tweakeroo");
    }

    private static Path getCurrentStorageFile(boolean globalData) {
        Path saveDir = WorldLoadListener.getCurrentConfigDirectory();
        if (!Files.exists(saveDir, new LinkOption[0])) {
            FileUtils.createDirectoriesIfMissing((Path)saveDir);
        }
        if (!Files.isDirectory(saveDir, new LinkOption[0])) {
            Tweakeroo.LOGGER.warn("getCurrentStorageFile(): Failed to create the config directory '{}'", (Object)saveDir.toAbsolutePath());
        }
        return saveDir.resolve(StringUtils.getStorageFileName((boolean)globalData, (String)"", (String)".json", (String)"tweakeroo_default"));
    }
}

