/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.data;

import fi.dy.masa.malilib.data.CachedBlockTags;
import fi.dy.masa.malilib.data.CachedTagKey;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_7923;

public class CachedTagManager {
    public static final CachedTagKey SILK_TOUCH_OVERRIDE_KEY = new CachedTagKey("tweakeroo", "silk_touch_override");
    public static final CachedTagKey NEEDS_SHEARS_KEY = new CachedTagKey("tweakeroo", "needs_shears");
    public static final CachedTagKey NEEDS_SILK_TOUCH_KEY = new CachedTagKey("tweakeroo", "needs_silk_touch");
    public static final CachedTagKey ORE_BLOCKS_KEY = new CachedTagKey("tweakeroo", "ore_blocks");

    public static void startCache() {
        CachedTagManager.clearCache();
        CachedBlockTags.getInstance().build(NEEDS_SHEARS_KEY, CachedTagManager.buildNeedsShearsCache());
        CachedBlockTags.getInstance().build(NEEDS_SILK_TOUCH_KEY, CachedTagManager.buildNeedsSilkTouchCache());
        CachedBlockTags.getInstance().build(ORE_BLOCKS_KEY, CachedTagManager.buildOreBlocksCache());
    }

    private static List<String> buildNeedsShearsCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + class_3481.field_15503.comp_327().toString());
        list.add("#" + class_3481.field_15481.comp_327().toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_28675).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_28676).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10343).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10428).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10112).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_28411).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_28686).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10313).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_22117).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_54733).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10479).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_56562).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10376).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10214).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_56563).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10238).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10589).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_23078).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_23079).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_22123).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_22124).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10597).toString());
        return list;
    }

    private static List<String> buildNeedsSilkTouchCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + class_3481.field_15490.comp_327().toString());
        list.add("#" + class_3481.field_15503.comp_327().toString());
        list.add("#" + class_3481.field_15488.comp_327().toString());
        list.add("#" + class_3481.field_15476.comp_327().toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10285).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10070).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_9982).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10163).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10355).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10077).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10419).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10193).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10129).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10305).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10469).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10496).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10565).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10152).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10118).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10578).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_9991).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_43231).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_37568).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_37570).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_28108).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_37571).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_37569).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_20422).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_20421).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10504).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10384).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_56454).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_17350).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_40276).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10443).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10295).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10225).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_23860).toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10195).toString());
        return list;
    }

    private static List<String> buildOreBlocksCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + class_3481.field_29193.comp_327().toString());
        list.add("#" + class_3481.field_29195.comp_327().toString());
        list.add("#" + class_3481.field_28989.comp_327().toString());
        list.add("#" + class_3481.field_29194.comp_327().toString());
        list.add("#" + class_3481.field_23062.comp_327().toString());
        list.add("#" + class_3481.field_28988.comp_327().toString());
        list.add("#" + class_3481.field_28991.comp_327().toString());
        list.add("#" + class_3481.field_28990.comp_327().toString());
        list.add(class_7923.field_41175.method_10221((Object)class_2246.field_10213).toString());
        return list;
    }

    public static void parseSilkTouchOverride(List<String> configStrs) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        if (configStrs.isEmpty()) {
            if (Configs.Generic.TOOL_SWAP_SILK_TOUCH_OVERRIDE.getBooleanValue()) {
                Tweakeroo.LOGGER.error("parseSilkTouchOverride: Config List '{}' is empty.", (Object)Configs.Lists.SILK_TOUCH_OVERRIDE.getName());
            }
            return;
        }
        CachedBlockTags.getInstance().clearEntry(SILK_TOUCH_OVERRIDE_KEY);
        CachedBlockTags.getInstance().build(SILK_TOUCH_OVERRIDE_KEY, configStrs);
    }

    private static void clearCache() {
        CachedBlockTags.getInstance().clearEntry(SILK_TOUCH_OVERRIDE_KEY);
        CachedBlockTags.getInstance().clearEntry(NEEDS_SHEARS_KEY);
        CachedBlockTags.getInstance().clearEntry(NEEDS_SILK_TOUCH_KEY);
        CachedBlockTags.getInstance().clearEntry(ORE_BLOCKS_KEY);
    }

    public static boolean isNeedsShears(class_2680 state) {
        return CachedBlockTags.getInstance().match(NEEDS_SHEARS_KEY, state);
    }

    public static boolean isNeedsSilkTouch(class_2680 state) {
        return CachedBlockTags.getInstance().match(NEEDS_SILK_TOUCH_KEY, state);
    }

    public static boolean isOreBlock(class_2680 state) {
        return CachedBlockTags.getInstance().match(ORE_BLOCKS_KEY, state);
    }

    public static boolean isSilkTouchOverride(class_2680 state) {
        return CachedBlockTags.getInstance().match(SILK_TOUCH_OVERRIDE_KEY, state);
    }
}

