/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import java.lang.reflect.Method;
import java.util.Collection;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public class FabricUtils {
    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean doesModFitsAnyPredicate(String modId, Collection<String> versionPredicates) {
        return FabricLoader.getInstance().getModContainer(modId).map(mod -> {
            Version version = mod.getMetadata().getVersion();
            return versionPredicates.isEmpty() || versionPredicates.stream().anyMatch(vp -> FabricUtils.doesVersionSatisfyPredicate(version, vp));
        }).orElse(false);
    }

    public static boolean doesVersionSatisfyPredicate(Version version, String versionPredicate) {
        try {
            return VersionPredicate.parse((String)versionPredicate).test((Object)version);
        }
        catch (NoClassDefFoundError e) {
            try {
                Class<?> clazz = Class.forName("net.fabricmc.loader.util.version.VersionPredicateParser");
                Method matches = clazz.getMethod("matches", Version.class, String.class);
                return (Boolean)matches.invoke(null, version, versionPredicate);
            }
            catch (Exception ex) {
                TweakerMoreMod.LOGGER.error("Failed to invoke VersionPredicateParser#matches", (Throwable)ex);
            }
        }
        catch (Exception e) {
            TweakerMoreMod.LOGGER.error("Failed to parse version or version predicate {} {}: {}", new Object[]{version.getFriendlyString(), versionPredicate, e});
        }
        return false;
    }
}

