/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.features.fireworkRocketThrottler;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import fi.dy.masa.malilib.util.InfoUtils;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Unique
    private long lastFireworkRocketUsageMilli = 0L;
    @Unique
    private final ThreadLocal<Boolean> nullPacketSkipping = ThreadLocal.withInitial(() -> false);

    @Inject(method={"method_41933"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireworkRocketThrottler_cancelIfCooldown_useOnBlock(CallbackInfoReturnable<class_2596<?>> cir, @Local(argsOnly=true) class_746 player, @Local(argsOnly=true) class_1268 hand, @Local(argsOnly=true) MutableObject<class_1269> actionResult) {
        if (this.checkCooldown((class_1657)player, hand)) {
            this.nullPacketSkipping.set(true);
            cir.setReturnValue(null);
            actionResult.setValue((Object)class_1269.field_5814);
        }
    }

    @Inject(method={"method_41929"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireworkRocketThrottler_cancelIfCooldown_useAtAir(CallbackInfoReturnable<class_2596<?>> cir, @Local(argsOnly=true) class_1657 player, @Local(argsOnly=true) class_1268 hand, @Local(argsOnly=true) MutableObject<class_1269> actionResult) {
        if (this.checkCooldown(player, hand)) {
            this.nullPacketSkipping.set(true);
            cir.setReturnValue(null);
            actionResult.setValue((Object)class_1269.field_5814);
        }
    }

    @Unique
    private boolean checkCooldown(class_1657 player, class_1268 hand) {
        class_1799 itemStack;
        if (TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER.getBooleanValue() && (itemStack = player.method_5998(hand)).method_7909() instanceof class_1781) {
            long now = System.currentTimeMillis();
            double cooldown = TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER_COOLDOWN.getDoubleValue();
            double remaining = cooldown - (double)(now - this.lastFireworkRocketUsageMilli) / 1000.0;
            if (remaining > 0.0) {
                InfoUtils.printActionbarMessage((String)"tweakermore.impl.fireworkRocketThrottler.throttled", (Object[])new Object[]{String.format("%.1f", remaining)});
                return true;
            }
        }
        return false;
    }

    @Inject(method={"startPrediction"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;predict(I)Lnet/minecraft/network/protocol/Packet;", shift=At.Shift.AFTER)}, cancellable=true)
    private void fireworkRocketThrottler_cancelSendSequencedPacketIfNull(CallbackInfo ci) {
        if (this.nullPacketSkipping.get().booleanValue()) {
            this.nullPacketSkipping.remove();
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"performUseItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;")})
    private class_1269 fireworkRocketThrottler_updateCooldown_useOnBlock(class_1269 actionResult) {
        this.updateCooldownOnUse(actionResult);
        return actionResult;
    }

    @ModifyExpressionValue(method={"method_41929"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    private class_1269 fireworkRocketThrottler_updateCooldown_useAtAir(class_1269 actionResult) {
        this.updateCooldownOnUse(actionResult);
        return actionResult;
    }

    @Unique
    private void updateCooldownOnUse(class_1269 actionResult) {
        if (TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER.getBooleanValue() && actionResult.method_23665()) {
            this.lastFireworkRocketUsageMilli = System.currentTimeMillis();
        }
    }
}

