/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer;

import com.google.common.collect.Queues;
import java.util.Queue;

public abstract class LimitedTaskRunner {
    protected final Queue<Runnable> queuedTasks = Queues.newArrayDeque();
    protected int taskExecutedThisRound = 0;
    private int cooldown = 0;

    protected LimitedTaskRunner() {
    }

    protected abstract int getMaxTaskPerTick();

    protected abstract int getTaskExecuteCooldown();

    private boolean runTask(Runnable runnable) {
        if (this.taskExecutedThisRound < this.getMaxTaskPerTick()) {
            ++this.taskExecutedThisRound;
            runnable.run();
            return true;
        }
        return false;
    }

    public void runOrEnqueueTask(Runnable runnable) {
        if (!this.runTask(runnable)) {
            this.queuedTasks.add(runnable);
        }
    }

    protected void tickTask() {
        Runnable task;
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = this.getTaskExecuteCooldown();
        this.taskExecutedThisRound = 0;
        while (!this.queuedTasks.isEmpty() && this.runTask(task = this.queuedTasks.peek())) {
            this.queuedTasks.poll();
        }
    }
}

