/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.windowSize;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;

public class WindowSizeHelper {
    public static void applyWindowSize() {
        class_1041 window = WindowSizeHelper.getMcWindow();
        if (window == null) {
            return;
        }
        if (window.method_4498()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"tweakermore.impl.windowSize.full_screen_nope", (Object[])new Object[0]);
            return;
        }
        WindowSizeHelper.applyWindowSizeImpl(window);
    }

    public static void onWindowSizeChanged(class_1041 window) {
        if (!TweakerMoreConfigs.WINDOW_SIZE_PINNED.getBooleanValue()) {
            return;
        }
        if (window.method_4498()) {
            return;
        }
        int windowWidth = window.method_4480();
        int windowHeight = window.method_4507();
        int configWidth = WindowSizeHelper.getConfigWidth();
        int configHeight = WindowSizeHelper.getConfigHeight();
        if (windowWidth != configWidth || windowHeight != configHeight) {
            TweakerMoreMod.LOGGER.debug("Window size was changed to ({}, {}) and is different to the configured size ({}, {}), resizing", new Object[]{windowWidth, windowHeight, configWidth, configHeight});
            WindowSizeHelper.applyWindowSizeImpl(window);
        }
    }

    public static void onConfigLoaded() {
        class_1041 window = WindowSizeHelper.getMcWindow();
        if (WindowSizeHelper.canPerformSizeChange(window)) {
            WindowSizeHelper.onWindowSizeChanged(window);
        }
    }

    private static class_1041 getMcWindow() {
        class_310 mc = class_310.method_1551();
        return mc.method_22683();
    }

    private static boolean canPerformSizeChange(class_1041 window) {
        return window != null && !window.method_4498();
    }

    private static int getConfigWidth() {
        return Math.max(1, TweakerMoreConfigs.WINDOW_SIZE_WIDTH.getIntegerValue());
    }

    private static int getConfigHeight() {
        return Math.max(1, TweakerMoreConfigs.WINDOW_SIZE_HEIGHT.getIntegerValue());
    }

    private static void applyWindowSizeImpl(class_1041 window) {
        if (window.method_4498()) {
            throw new RuntimeException("resize in full screen");
        }
        GLFW.glfwSetWindowSize((long)window.method_4490(), (int)WindowSizeHelper.getConfigWidth(), (int)WindowSizeHelper.getConfigHeight());
    }
}

