/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.config.comment;

import com.google.common.collect.ImmutableMap;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;

public class TagProcessor {
    private static final Map<String, Transformer> TRANSFORMERS = ImmutableMap.of((Object)"tr", TagProcessor::transformTranslation, (Object)"option", TagProcessor::transformOption);

    public static String processReferences(String comment) {
        String patternString = "@([a-zA-Z0-9]+)#([a-zA-Z0-9.]+)@";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(comment);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String type = matcher.group(1);
            String value = matcher.group(2);
            Transformer transformer = TRANSFORMERS.getOrDefault(type, s -> matcher.group());
            matcher.appendReplacement(sb, transformer.transform(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String transformTranslation(String translationKey) {
        return StringUtils.translate((String)translationKey, (Object[])new Object[0]);
    }

    private static String transformOption(String optionName) {
        return TweakerMoreConfigs.getOptionByName(optionName).map(config -> {
            String displayName = config.getConfig().getConfigGuiDisplayName();
            return GuiBase.TXT_YELLOW + displayName + GuiBase.TXT_RST;
        }).orElse(optionName);
    }

    @FunctionalInterface
    private static interface Transformer {
        public String transform(String var1);
    }
}

