/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.util;

import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.litematica.schematic.SchematicMetadata;
import ch.endte.syncmatica.litematica.schematic.SchematicSchema;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import org.apache.commons.lang3.tuple.Pair;

public class SyncmaticaUtil {
    public static final int[] ILLEGAL_CHARS = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};
    public static final String ILLEGAL_PATTERNS = "(^(con|prn|aux|nul|com[0-9]|lpt[0-9])(\\..*)?$)|(^\\.\\.*$)";
    public static final String REGEX_SANITIZE = "[\\\\/:*?\"<>|]|\\p{C}|\\p{M}";

    private SyncmaticaUtil() {
    }

    public static UUID createChecksum(InputStream fis) throws NoSuchAlgorithmException, IOException {
        int numRead;
        byte[] buffer = new byte[4096];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            messageDigest.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        return UUID.nameUUIDFromBytes(messageDigest.digest());
    }

    public static String sanitizeFileName(String badFileName) {
        StringBuilder sanitized = new StringBuilder();
        int len = badFileName.codePointCount(0, badFileName.length());
        for (int i = 0; i < len; ++i) {
            int c = badFileName.codePointAt(i);
            if (Arrays.binarySearch(ILLEGAL_CHARS, c) >= 0) continue;
            sanitized.appendCodePoint(c);
            if (sanitized.length() == 255) break;
        }
        return sanitized.toString().replaceAll(ILLEGAL_PATTERNS, "_");
    }

    public static String sanitizeUnicodeFileName(String fileIn) {
        return fileIn.replaceAll(REGEX_SANITIZE, "_").stripLeading().stripTrailing();
    }

    public static String sanitizeUnicodeSubDirFileName(String badFileName) {
        int i;
        String[] split;
        StringBuilder builder = new StringBuilder();
        String current = badFileName;
        if (badFileName.contains("/")) {
            split = current.split("/");
            if (split.length > 1) {
                builder.append(SyncmaticaUtil.sanitizeUnicodeFileName(split[0]));
                for (i = 1; i < split.length; ++i) {
                    builder.append("/").append(SyncmaticaUtil.sanitizeUnicodeFileName(split[i]));
                }
            } else {
                builder.append(SyncmaticaUtil.sanitizeUnicodeFileName(split[0]));
            }
            current = builder.toString();
            builder = new StringBuilder();
        }
        if (badFileName.contains("\\")) {
            split = current.split("\\\\");
            if (split.length > 1) {
                builder.append(SyncmaticaUtil.sanitizeUnicodeFileName(split[0]));
                for (i = 1; i < split.length; ++i) {
                    builder.append("\\").append(SyncmaticaUtil.sanitizeUnicodeFileName(split[i]));
                }
            } else {
                builder.append(SyncmaticaUtil.sanitizeUnicodeFileName(split[0]));
            }
            current = builder.toString();
        }
        return current;
    }

    public static void backupAndReplace(Path backup, Path current, Path incoming) {
        if (!Files.exists(incoming, new LinkOption[0])) {
            return;
        }
        if (SyncmaticaUtil.overwrite(backup, current, 2) && !SyncmaticaUtil.overwrite(current, incoming, 4)) {
            SyncmaticaUtil.overwrite(current, backup, 8);
        }
    }

    private static boolean overwrite(Path backup, Path current, int tries) {
        if (!Files.exists(current, new LinkOption[0])) {
            return true;
        }
        try {
            Files.deleteIfExists(backup);
            Files.move(current, backup, new CopyOption[0]);
        }
        catch (IOException exception) {
            if (tries <= 0) {
                Syncmatica.LOGGER.error("Excessive retries when trying to write Syncmatica placement", (Throwable)exception);
                return false;
            }
            return SyncmaticaUtil.overwrite(backup, current, tries - 1);
        }
        return true;
    }

    public static double getBlockDistanceSquared(class_2338 a, double x, double y, double z) {
        double combinedX = (double)a.method_10263() - x;
        double combinedY = (double)a.method_10264() - y;
        double combinedZ = (double)a.method_10260() - z;
        return combinedX * combinedX + combinedY * combinedY + combinedZ * combinedZ;
    }

    public static class_2487 readNbtFromFile(@Nonnull Path file) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return new class_2487();
        }
        try {
            return class_2507.method_10629((InputStream)Files.newInputStream(file, new OpenOption[0]), (class_2505)class_2505.method_53898());
        }
        catch (Exception e) {
            Syncmatica.LOGGER.warn("readNbtFromFile: Failed to read NBT data from file '{}'", (Object)file.toString());
            return new class_2487();
        }
    }

    public static Pair<SchematicMetadata, SchematicSchema> litematicPeek(Path file) {
        class_2487 nbt = SyncmaticaUtil.readNbtFromFile(file);
        if (nbt.method_33133() || !nbt.method_10545("Metadata")) {
            return Pair.of(null, null);
        }
        int version = nbt.method_10545("Version") ? nbt.method_68083("Version", -1) : -1;
        int dataVersion = nbt.method_10545("MinecraftDataVersion") ? nbt.method_68083("MinecraftDataVersion", -1) : -1;
        SchematicMetadata metadata = new SchematicMetadata();
        class_2487 tags = nbt.method_68568("Metadata");
        if (!tags.method_33133()) {
            metadata.readFromNBT(tags);
        }
        return Pair.of((Object)metadata, (Object)new SchematicSchema(version, dataVersion));
    }

    @Nonnull
    public static class_2487 createVec3iTag(@Nonnull class_2382 pos) {
        return SyncmaticaUtil.putVec3i(new class_2487(), pos);
    }

    @Nonnull
    public static class_2487 putVec3i(@Nonnull class_2487 tag, @Nonnull class_2382 pos) {
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("y", pos.method_10264());
        tag.method_10569("z", pos.method_10260());
        return tag;
    }

    @Nullable
    public static class_2382 readVec3iFromTag(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("x") && tag.method_10545("y") && tag.method_10545("z")) {
            return new class_2382(tag.method_68083("x", 0), tag.method_68083("y", 0), tag.method_68083("z", 0));
        }
        return null;
    }

    static {
        Arrays.sort(ILLEGAL_CHARS);
    }
}

