/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.data.ServerPlacement;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.function.Consumer;

public class ScreenHelper {
    private static ScreenHelper instance;
    private Consumer<ServerPlacement> updateListener;
    private GuiBase currentGui = null;
    private Context context;

    public static void ifPresent(Consumer<ScreenHelper> callable) {
        if (instance != null) {
            callable.accept(instance);
        }
    }

    public static void init() {
        if (instance != null) {
            instance.detach();
        }
        instance = new ScreenHelper();
    }

    public static void close() {
        if (instance != null) {
            instance.detach();
        }
        instance = null;
    }

    private ScreenHelper() {
    }

    public void setActiveContext(Context con) {
        this.detach();
        this.context = con;
        this.attach();
        this.updateCurrentScreen();
    }

    public void setCurrentGui(GuiBase gui) {
        this.currentGui = gui;
    }

    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        InfoUtils.showGuiOrInGameMessage((Message.MessageType)type, (String)messageKey, (Object[])args);
    }

    private void updateCurrentScreen() {
        if (this.currentGui != null) {
            this.currentGui.initGui();
        }
    }

    private void attach() {
        this.updateListener = p -> this.updateCurrentScreen();
        this.context.getSyncmaticManager().addServerPlacementConsumer(this.updateListener);
    }

    private void detach() {
        if (this.context != null) {
            this.context.getSyncmaticManager().removeServerPlacementConsumer(this.updateListener);
        }
    }
}

