/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica;

import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.litematica.LitematicManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.interfaces.ISchematicPlacementEventListener;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PlacementEventHandler
implements ISchematicPlacementEventListener {
    private final HashMap<UUID, UUID> serverIds = new HashMap();

    protected void setServerId(SchematicPlacement placement, UUID id) {
        if (placement != null) {
            Syncmatica.debug("PlacementEventHandler#setServerId() - name: [{}], ID: [{}]", placement.getName(), id.toString());
            this.serverIds.put(placement.getHashId(), id);
        }
    }

    @Nullable
    protected UUID getServerId(SchematicPlacement placement) {
        if (placement != null && this.serverIds.containsKey(placement.getHashId())) {
            Syncmatica.debug("PlacementEventHandler#getServerId():A: - name: [{}], ID: [{}]", placement.getName(), this.serverIds.get(placement.getHashId()).toString());
            return this.serverIds.get(placement.getHashId());
        }
        Syncmatica.LOGGER.warn("PlacementEventHandler#getServerId() - name: [{}] --> NOT FOUND!", (Object)(placement != null ? placement.getName() : "<NULL>"));
        return null;
    }

    protected boolean hasServerId(SchematicPlacement placement) {
        return this.serverIds.containsKey(placement.getHashId());
    }

    protected void clearServerId(SchematicPlacement placement) {
        if (placement != null) {
            Syncmatica.debug("PlacementEventHandler#clearServerId() - name: [{}]", placement.getName());
            this.serverIds.remove(placement.getHashId());
        }
    }

    protected void clear() {
        Syncmatica.debug("PlacementEventHandler#clear()", new Object[0]);
        this.serverIds.clear();
    }

    public void onPlacementInit(SchematicPlacement placement) {
    }

    public void onPlacementCreateFromJson(SchematicPlacement placement, LitematicaSchematic litematicaSchematic, class_2338 blockPos, String s, class_2470 blockRotation, class_2415 blockMirror, boolean enabled, boolean renderEnabled, JsonObject obj) {
        if (JsonUtils.hasString((JsonObject)obj, (String)"syncmatica_uuid") && placement != null) {
            String id = obj.get("syncmatica_uuid").getAsString();
            Syncmatica.debug("PlacementEventHandler#onPlacementCreateFromJson(): name: [{}], id: [{}]", placement.getName(), id);
            this.setServerId(placement, UUID.fromString(id));
            LitematicManager.getInstance().preLoad(placement);
        }
    }

    public void onPlacementCreateFromNbt(SchematicPlacement placement, LitematicaSchematic litematicaSchematic, class_2338 blockPos, String s, class_2470 blockRotation, class_2415 blockMirror, boolean enabled, boolean renderEnabled, class_2487 nbt) {
        if (nbt.method_10545("syncmatica_uuid") && placement != null) {
            String id = nbt.method_68564("syncmatica_uuid", "");
            Syncmatica.debug("PlacementEventHandler#onPlacementCreateFromNbt(): name: [{}], id: [{}]", placement.getName(), id);
            this.setServerId(placement, UUID.fromString(id));
            LitematicManager.getInstance().preLoad(placement);
        }
    }

    public void onSavePlacementToJson(SchematicPlacement placement, JsonObject obj) {
        UUID serverId = this.getServerId(placement);
        if (serverId != null) {
            Syncmatica.debug("PlacementEventHandler#onSavePlacementToJson(): name: [{}], id: [{}]", placement.getName(), serverId.toString());
            obj.add("syncmatica_uuid", (JsonElement)new JsonPrimitive(serverId.toString()));
        } else {
            Syncmatica.LOGGER.warn("PlacementEventHandler#onSavePlacementToJson(): name: [{}] --> NOT FOUND!", (Object)placement.getName());
        }
    }

    public void onSavePlacementToNbt(SchematicPlacement placement, class_2487 nbt) {
        UUID serverId = this.getServerId(placement);
        if (serverId != null) {
            Syncmatica.debug("PlacementEventHandler#onSavePlacementToNbt(): name: [{}], id: [{}]", placement.getName(), serverId.toString());
            nbt.method_10582("syncmatica_uuid", serverId.toString());
        } else {
            Syncmatica.LOGGER.warn("PlacementEventHandler#onSavePlacementToNbt(): name: [{}] --> NOT FOUND!", (Object)placement.getName());
        }
    }

    public void onPlacementAdded(SchematicPlacement placement) {
        ServerPlacement serverPlacement;
        if (!this.hasServerId(placement) && LitematicManager.getInstance().isSyncmatic(placement) && (serverPlacement = LitematicManager.getInstance().getRenderingSyncmatic(placement)) != null) {
            this.setServerId(placement, serverPlacement.getId());
            LitematicManager.getInstance().preLoad(placement);
        }
    }

    public void onPlacementRemoved(SchematicPlacement placement) {
        LitematicManager.getInstance().unrenderSchematic(placement.getSchematic());
    }
}

