/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.data;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Reference;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class SyncmaticManager {
    public static final String PLACEMENTS_JSON_KEY = "placements";
    private final Map<UUID, ServerPlacement> schematics = new HashMap<UUID, ServerPlacement>();
    private final Collection<Consumer<ServerPlacement>> consumers = new ArrayList<Consumer<ServerPlacement>>();
    Context context;

    public void setContext(Context con) {
        if (this.context != null) {
            throw new Context.DuplicateContextAssignmentException("Duplicate Context assignment");
        }
        this.context = con;
    }

    public void addPlacement(ServerPlacement placement) {
        this.schematics.put(placement.getId(), placement);
        this.updateServerPlacement(placement);
    }

    public ServerPlacement getPlacement(UUID id) {
        return this.schematics.get(id);
    }

    public Collection<ServerPlacement> getAll() {
        return this.schematics.values();
    }

    public boolean hasPlacementHash(UUID hash) {
        AtomicBoolean bool = new AtomicBoolean(false);
        this.getAll().forEach(p -> {
            if (p.getHash().compareTo(hash) == 0) {
                bool.set(true);
            }
        });
        return bool.get();
    }

    public void removePlacement(ServerPlacement placement) {
        this.schematics.remove(placement.getId());
        this.updateServerPlacement(placement);
    }

    public void addServerPlacementConsumer(Consumer<ServerPlacement> consumer) {
        this.consumers.add(consumer);
    }

    public void removeServerPlacementConsumer(Consumer<ServerPlacement> consumer) {
        this.consumers.remove(consumer);
    }

    public void updateServerPlacement(ServerPlacement updated) {
        for (Consumer<ServerPlacement> consumer : this.consumers) {
            consumer.accept(updated);
        }
        if (this.context.isServer()) {
            this.saveServer();
        }
    }

    public void startup() {
        if (this.context.isServer()) {
            this.loadServer();
        }
    }

    public void shutdown() {
        if (this.context.isServer()) {
            this.saveServer();
        }
    }

    private void saveServer() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        for (ServerPlacement p : this.getAll()) {
            arr.add((JsonElement)p.toJson());
        }
        obj.add(PLACEMENTS_JSON_KEY, (JsonElement)arr);
        Path backup = this.context.getConfigFolder().resolve("placements.json.bak");
        Path incoming = this.context.getConfigFolder().resolve("placements.json.new");
        Path current = this.context.getConfigFolder().resolve("placements.json");
        Syncmatica.debug("saveServer(): placements path: '{}'", current.toAbsolutePath().toString());
        try (FileWriter writer = new FileWriter(incoming.toFile());){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj));
        }
        catch (IOException e) {
            Syncmatica.LOGGER.error("saveServer(): Exception writing incoming file '{}'; {}", (Object)incoming.getFileName().toString(), (Object)e.getLocalizedMessage());
            e.printStackTrace();
            return;
        }
        SyncmaticaUtil.backupAndReplace(backup, current, incoming);
    }

    private void loadServer() {
        Path f = this.context.getConfigFolder().resolve("placements.json");
        Path upgrade = Reference.CONFIG_ROOT.resolve("syncmatica").normalize().resolve("placements.json");
        if (Files.exists(upgrade, new LinkOption[0])) {
            try {
                if (!Files.exists(f, new LinkOption[0]) && Files.isRegularFile(upgrade, new LinkOption[0])) {
                    Syncmatica.LOGGER.warn("loadServer(): Migrating '{}' to: '{}'", (Object)upgrade.toAbsolutePath().toString(), (Object)f.toAbsolutePath().toString());
                    Files.move(upgrade, f, new CopyOption[0]);
                } else if (Files.isRegularFile(upgrade, new LinkOption[0])) {
                    Path oldFile = this.context.getConfigFolder().resolve("placements.json.old");
                    Syncmatica.LOGGER.warn("loadServer(): Backing up stale '{}' to: '{}'", (Object)upgrade.toAbsolutePath().toString(), (Object)oldFile.toAbsolutePath().toString());
                    Files.move(upgrade, oldFile, new CopyOption[0]);
                }
            }
            catch (Exception e) {
                Syncmatica.LOGGER.error("loadServer(): Exception moving upgrade file '{}'; {}", (Object)upgrade.getFileName().toString(), (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        Syncmatica.debug("loadServer(): placements path: [{}]", f.toAbsolutePath().toString());
        if (Files.exists(f, new LinkOption[0]) && Files.isReadable(f)) {
            JsonElement element = null;
            try {
                FileReader reader = new FileReader(f.toFile());
                element = JsonParser.parseReader((Reader)reader);
                reader.close();
            }
            catch (Exception e) {
                Syncmatica.LOGGER.error("loadServer(): Exception reading file '{}'; {}", (Object)f.getFileName().toString(), (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
            if (element == null) {
                return;
            }
            try {
                JsonObject obj = element.getAsJsonObject();
                if (obj == null || !obj.has(PLACEMENTS_JSON_KEY)) {
                    return;
                }
                JsonArray arr = obj.getAsJsonArray(PLACEMENTS_JSON_KEY);
                boolean dirty = false;
                for (JsonElement elem : arr) {
                    ServerPlacement placement = ServerPlacement.fromJson(elem.getAsJsonObject(), this.context);
                    if (placement == null) continue;
                    if (placement.isDirty()) {
                        dirty = true;
                    }
                    this.schematics.put(placement.getId(), placement);
                }
                if (dirty) {
                    Syncmatica.LOGGER.warn("loadServer(): Found a dirty placements.json; re-saving with corrections.");
                    this.saveServer();
                }
            }
            catch (IllegalStateException | NullPointerException e) {
                Syncmatica.LOGGER.error("loadServer(): Exception loading server placement; {}", (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }
}

