/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.data;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.data.FileStorage;
import ch.endte.syncmatica.data.IFileStorage;
import ch.endte.syncmatica.data.LocalLitematicState;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class RedirectFileStorage
implements IFileStorage {
    private final IFileStorage fs;
    private final Map<UUID, RedirectData> redirect = new HashMap<UUID, RedirectData>();

    public RedirectFileStorage() {
        this.fs = new FileStorage();
    }

    public void addRedirect(Path file) {
        RedirectData red = new RedirectData(this, file);
        this.redirect.put(red.getHash(), red);
    }

    @Override
    public LocalLitematicState getLocalState(ServerPlacement placement) {
        UUID hashId = placement.getHash();
        if (this.redirect.containsKey(hashId) && hashId.equals(this.redirect.get(hashId).getHash())) {
            return LocalLitematicState.LOCAL_LITEMATIC_PRESENT;
        }
        return this.fs.getLocalState(placement);
    }

    @Override
    public Path createLocalLitematic(ServerPlacement placement) {
        return this.fs.createLocalLitematic(placement);
    }

    @Override
    public Path getLocalLitematic(ServerPlacement placement) {
        UUID hashId = placement.getHash();
        if (this.redirect.containsKey(hashId)) {
            RedirectData red = this.redirect.get(hashId);
            if (red.exists() && hashId.equals(red.getHash())) {
                return red.redirect;
            }
            this.redirect.remove(hashId);
        }
        return this.fs.getLocalLitematic(placement);
    }

    @Override
    public void setContext(Context con) {
        this.fs.setContext(con);
    }

    private class RedirectData {
        Path redirect = null;
        UUID hash = null;
        long hashTimeStamp;

        RedirectData(RedirectFileStorage redirectFileStorage, Path file) {
            this.redirect = file;
            this.getHash();
            if (this.hash == null) {
                file = null;
            }
        }

        UUID getHash() {
            if (this.hashTimeStamp == this.getModifiedTime()) {
                return this.hash;
            }
            try {
                this.hash = SyncmaticaUtil.createChecksum(new FileInputStream(this.redirect.toFile()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            this.hashTimeStamp = this.getModifiedTime();
            return this.hash;
        }

        long getModifiedTime() {
            try {
                return Files.getLastModifiedTime(this.redirect, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                Syncmatica.LOGGER.warn("Exception getting last modified time of file [{}]", (Object)this.redirect.getFileName().toString());
                return System.currentTimeMillis();
            }
        }

        boolean exists() {
            return Files.exists(this.redirect, new LinkOption[0]) && Files.isReadable(this.redirect);
        }
    }
}

