/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.communication.exchange.Exchange;
import ch.endte.syncmatica.network.PacketType;
import ch.endte.syncmatica.network.SyncmaticaPacket;
import ch.endte.syncmatica.network.handler.ClientPlayHandler;
import ch.endte.syncmatica.network.handler.ServerPlayHandler;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_3244;
import net.minecraft.class_634;

public class ExchangeTarget {
    public final class_634 clientPlayNetworkHandler;
    public final class_3244 serverPlayNetworkHandler;
    private final String persistentName;
    private FeatureSet features;
    private final List<Exchange> ongoingExchanges = new ArrayList<Exchange>();

    public ExchangeTarget(class_634 clientPlayContext) {
        this.clientPlayNetworkHandler = clientPlayContext;
        this.serverPlayNetworkHandler = null;
        this.persistentName = StringUtils.getWorldOrServerName();
    }

    public ExchangeTarget(class_3244 serverPlayContext) {
        this.clientPlayNetworkHandler = null;
        this.serverPlayNetworkHandler = serverPlayContext;
        this.persistentName = serverPlayContext.method_32311().method_5845();
    }

    public void sendPacket(PacketType type, class_2540 byteBuf, Context context) {
        SyncmaticaPacket newPacket;
        if (context != null) {
            context.getDebugService().logSendPacket(type, this.persistentName);
        }
        if ((newPacket = new SyncmaticaPacket(type.getId(), byteBuf)).getType() == null) {
            Syncmatica.LOGGER.error("ExchangeTarget#sendPacket(): error, PacketType {} resulted in a null Payload", (Object)type.toString());
            return;
        }
        if (this.clientPlayNetworkHandler != null) {
            ClientPlayHandler.encodeSyncData(newPacket, this.clientPlayNetworkHandler);
        }
        if (this.serverPlayNetworkHandler != null) {
            ServerPlayHandler.encodeSyncData(newPacket, this.serverPlayNetworkHandler);
        }
    }

    public FeatureSet getFeatureSet() {
        return this.features;
    }

    public void setFeatureSet(FeatureSet f) {
        this.features = f;
    }

    public Collection<Exchange> getExchanges() {
        return this.ongoingExchanges;
    }

    public String getPersistentName() {
        return this.persistentName;
    }

    public boolean isServer() {
        return this.serverPlayNetworkHandler != null;
    }

    public boolean isClient() {
        return this.clientPlayNetworkHandler != null;
    }
}

