/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.command;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.command.IServerCommand;
import ch.endte.syncmatica.communication.ServerCommunicationManager;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.data.ServerPosition;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.litematica.schematic.SchematicMetadata;
import ch.endte.syncmatica.litematica.schematic.SchematicSchema;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_12094;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_7157;
import org.apache.commons.lang3.tuple.Pair;

public class SyncmaticaCommand
implements IServerCommand {
    public static final SyncmaticaCommand INSTANCE = new SyncmaticaCommand();
    private Context context = null;
    private final HashMap<Path, Pair<SchematicMetadata, SchematicSchema>> files = new HashMap();
    private final class_12094 DEFAULT_PERMISSIONS = class_12094.field_63196;

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"syncmatica").requires(Permissions.require((String)"syncmatica.command", (class_12094)this.DEFAULT_PERMISSIONS))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"load").requires(Permissions.require((String)"syncmatica.command.load", (class_12094)this.DEFAULT_PERMISSIONS))).executes(this::doLoadAll)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_35510(this.files.keySet(), (SuggestionsBuilder)builder, ent -> ServerPlacement.removeExtension(ent.getFileName().toString()), ent2 -> this.formatTooltip((SchematicMetadata)this.files.get(ent2).getLeft()))).requires(Permissions.require((String)"syncmatica.command.load_each", (class_12094)this.DEFAULT_PERMISSIONS))).executes(ctx -> {
            String result = StringArgumentType.getString((CommandContext)ctx, (String)"file");
            return this.doLoadEach((CommandContext<class_2168>)ctx, result);
        }))));
    }

    public void updateSyncmaticDir(Context context) {
        ArrayList<Path> list = new ArrayList<Path>();
        this.files.clear();
        if (context == null) {
            return;
        }
        if (this.context == null) {
            this.context = context;
        }
        if (context.isServer()) {
            Path dir = context.getLitematicFolder();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path file : stream) {
                    if (Files.isDirectory(file, new LinkOption[0])) continue;
                    list.add(file);
                }
            }
            catch (Exception e) {
                Syncmatica.LOGGER.error("updateSyncmaticDir(): Exception reading directory '{}'; {}", (Object)dir.toAbsolutePath().toString(), (Object)e.getLocalizedMessage());
            }
        }
        list.forEach(p -> {
            Pair<SchematicMetadata, SchematicSchema> pair;
            String name = ServerPlacement.removeExtension(p.getFileName());
            UUID hash = UUID.fromString(name);
            if (!context.getSyncmaticManager().hasPlacementHash(hash) && (pair = SyncmaticaUtil.litematicPeek(p)).getLeft() != null) {
                this.files.put((Path)p, pair);
            }
        });
    }

    private class_2561 formatTooltip(SchematicMetadata meta) {
        return class_2561.method_30163((String)meta.getName());
    }

    private int doLoadAll(CommandContext<class_2168> ctx) {
        class_4208 globalPos;
        PlayerIdentifier owner;
        if (this.context == null) {
            return 0;
        }
        if (this.files.isEmpty()) {
            this.updateSyncmaticDir(this.context);
        }
        if (this.files.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"No Syncmatic file(s) found that needs to be loaded."), false);
            return 0;
        }
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player != null) {
            owner = this.context.getPlayerIdentifierProvider().createOrGet(player.method_7334());
            globalPos = new class_4208(player.method_51469().method_27983(), player.method_24515());
        } else {
            owner = this.context.getPlayerIdentifierProvider().createOrGet(UUID.randomUUID(), "Unknown");
            globalPos = new class_4208(class_1937.field_25179, class_2338.field_10980);
        }
        AtomicInteger count = new AtomicInteger();
        PlayerIdentifier finalOwner = owner;
        class_4208 finalGlobalPos = globalPos;
        this.files.forEach((p, pair) -> {
            if (this.loadEach((class_2168)ctx.getSource(), (Path)p, (SchematicMetadata)pair.getLeft(), (SchematicSchema)pair.getRight(), finalOwner, finalGlobalPos)) {
                count.getAndIncrement();
            }
        });
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)("\u00a7b" + String.format("%02d", count.get()) + "\u00a7r Syncmatic file(s) found / loaded.")), true);
        this.updateSyncmaticDir(this.context);
        return 1;
    }

    private boolean loadEach(class_2168 src, Path p, SchematicMetadata meta, SchematicSchema schema, PlayerIdentifier owner, class_4208 pos) {
        ServerPlacement placement = new ServerPlacement(UUID.randomUUID(), p.normalize(), p.getFileName().toString(), owner);
        placement = placement.move(ServerPosition.fromGlobalPos(pos), class_2470.field_11467, class_2415.field_11302);
        placement = placement.setMetadata(meta);
        placement = placement.setSchema(schema);
        ServerCommunicationManager comms = (ServerCommunicationManager)this.context.getCommunicationManager();
        comms.addPlacement(comms.fromExistingPlayer(src.method_44023()), placement);
        String name = placement.getName();
        src.method_9226(() -> class_2561.method_30163((String)("Loaded Server Placement '\u00a7d" + name + "\u00a7r'")), true);
        return true;
    }

    private int doLoadEach(CommandContext<class_2168> ctx, String result) {
        class_4208 globalPos;
        PlayerIdentifier owner;
        if (this.files.isEmpty()) {
            this.updateSyncmaticDir(this.context);
        }
        if (this.files.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"No Syncmatic file(s) found that needs to be loaded."), false);
            return 0;
        }
        Path dir = this.context.getLitematicFolder();
        Path file = dir.resolve(result + ".litematic");
        Pair<SchematicMetadata, SchematicSchema> pair = SyncmaticaUtil.litematicPeek(file);
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player != null) {
            owner = this.context.getPlayerIdentifierProvider().createOrGet(player.method_7334());
            globalPos = new class_4208(player.method_51469().method_27983(), player.method_24515());
        } else {
            owner = this.context.getPlayerIdentifierProvider().createOrGet(UUID.randomUUID(), "Unknown");
            globalPos = new class_4208(class_1937.field_25179, class_2338.field_10980);
        }
        if (this.loadEach((class_2168)ctx.getSource(), file, (SchematicMetadata)pair.getLeft(), (SchematicSchema)pair.getRight(), owner, globalPos)) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"\u00a7b01\u00a7r Syncmatic file(s) found / loaded."), true);
        }
        this.updateSyncmaticDir(this.context);
        return 1;
    }
}

