/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.minecraft;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import net.minecraft.class_12279;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3283;
import net.minecraft.class_5352;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;

public abstract class MinecraftWorldInfoProvider
implements WorldInfoProvider {
    protected abstract class_3283 getPackRepository();

    @Override
    public Collection<WorldInfoProvider.DataPackInfo> pollDataPacks() {
        return this.getPackRepository().method_14444().stream().map(pack -> new WorldInfoProvider.DataPackInfo(pack.method_14463(), pack.method_14459().getString(), MinecraftWorldInfoProvider.resourcePackSource(pack.method_29483()))).collect(Collectors.toList());
    }

    private static String resourcePackSource(class_5352 source) {
        if (source == class_5352.field_25347) {
            return "none";
        }
        if (source == class_5352.field_25348) {
            return "builtin";
        }
        if (source == class_5352.field_25349) {
            return "world";
        }
        if (source == class_5352.field_25350) {
            return "server";
        }
        return "unknown";
    }

    static final class MinecraftChunkInfo
    extends AbstractChunkInfo<class_1299<?>> {
        private final CountMap<class_1299<?>> entityCounts = new CountMap.Simple(new HashMap());

        MinecraftChunkInfo(long chunkPos) {
            super(class_1923.method_8325((long)chunkPos), class_1923.method_8332((long)chunkPos));
        }

        @Override
        public CountMap<class_1299<?>> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(class_1299<?> type) {
            return class_1299.method_5890(type).toString();
        }
    }

    public static abstract class Client
    extends MinecraftWorldInfoProvider {
        private final class_310 client;

        public Client(class_310 client) {
            this.client = client;
        }

        protected abstract int countEntities(class_638 var1);

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            class_638 level = this.client.field_1687;
            if (level == null) {
                return null;
            }
            int entities = this.countEntities(level);
            int chunks = level.method_2935().method_14151();
            return new WorldInfoProvider.CountsResult(-1, entities, -1, chunks);
        }

        protected abstract Iterable<class_1297> getAllEntities(class_638 var1);

        public WorldInfoProvider.ChunksResult<MinecraftChunkInfo> pollChunks() {
            class_638 level = this.client.field_1687;
            if (level == null) {
                return null;
            }
            WorldInfoProvider.ChunksResult<MinecraftChunkInfo> data = new WorldInfoProvider.ChunksResult<MinecraftChunkInfo>();
            Long2ObjectOpenHashMap worldInfos = new Long2ObjectOpenHashMap();
            for (class_1297 entity : this.getAllEntities(level)) {
                MinecraftChunkInfo info = (MinecraftChunkInfo)worldInfos.computeIfAbsent(entity.method_31476().method_8324(), MinecraftChunkInfo::new);
                info.entityCounts.increment(entity.method_5864());
            }
            data.put(level.method_27983().method_29177().method_12832(), List.copyOf(worldInfos.values()));
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            return null;
        }

        @Override
        protected class_3283 getPackRepository() {
            return this.client.method_1520();
        }
    }

    public static abstract class Server
    extends MinecraftWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        protected abstract int countEntities(class_3218 var1);

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int players = this.server.method_3788();
            int entities = 0;
            int chunks = 0;
            for (class_3218 level : this.server.method_3738()) {
                entities += this.countEntities(level);
                chunks += level.method_14178().method_14151();
            }
            return new WorldInfoProvider.CountsResult(players, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<MinecraftChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<MinecraftChunkInfo> data = new WorldInfoProvider.ChunksResult<MinecraftChunkInfo>();
            for (class_3218 level : this.server.method_3738()) {
                Long2ObjectOpenHashMap worldInfos = new Long2ObjectOpenHashMap();
                for (class_1297 entity : level.method_27909()) {
                    MinecraftChunkInfo info = (MinecraftChunkInfo)worldInfos.computeIfAbsent(entity.method_31476().method_8324(), MinecraftChunkInfo::new);
                    info.entityCounts.increment(entity.method_5864());
                }
                data.put(level.method_27983().method_29177().method_12832(), List.copyOf(worldInfos.values()));
            }
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            WorldInfoProvider.GameRulesResult data = new WorldInfoProvider.GameRulesResult();
            Iterable worlds = this.server.method_3738();
            for (class_3218 level : worlds) {
                String levelName = level.method_27983().method_29177().method_12832();
                level.method_64395().method_76181().forEach(rule -> {
                    String defaultValue = Server.gameRuleDefaultValue(rule);
                    data.putDefault(rule.method_76144(), defaultValue);
                    String value = level.method_64395().method_76200(rule);
                    data.put(rule.method_76144(), levelName, value);
                });
            }
            return data;
        }

        private static <T> String gameRuleDefaultValue(class_12279<T> rule) {
            return rule.method_76146(rule.method_76156());
        }

        @Override
        protected class_3283 getPackRepository() {
            return this.server.method_3836();
        }
    }
}

