/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.plugin;

import java.util.Collection;
import java.util.stream.Collectors;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.sampler.source.SourceMetadata;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.fabric.FabricClassSourceLookup;
import me.lucko.spark.fabric.FabricPlatformInfo;
import me.lucko.spark.fabric.FabricServerCommandSender;
import me.lucko.spark.fabric.FabricSparkMod;
import me.lucko.spark.fabric.FabricTickHook;
import me.lucko.spark.fabric.FabricTickReporter;
import me.lucko.spark.fabric.FabricWorldInfoProvider;
import me.lucko.spark.fabric.placeholder.SparkFabricPlaceholderApi;
import me.lucko.spark.minecraft.plugin.MinecraftServerSparkPlugin;
import me.lucko.spark.minecraft.sender.MinecraftServerCommandSender;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class FabricServerSparkPlugin
extends MinecraftServerSparkPlugin<FabricSparkMod> {
    public static FabricServerSparkPlugin init(FabricSparkMod mod, MinecraftServer server) {
        FabricServerSparkPlugin plugin = new FabricServerSparkPlugin(mod, server);
        plugin.enable();
        return plugin;
    }

    public FabricServerSparkPlugin(FabricSparkMod mod, MinecraftServer server) {
        super(mod, server);
    }

    @Override
    public void enable() {
        super.enable();
        if (FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            try {
                SparkFabricPlaceholderApi.register(this.platform);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
    }

    @Override
    protected MinecraftServerCommandSender createCommandSender(class_2168 source) {
        return new FabricServerCommandSender(source);
    }

    @Override
    public TickHook createTickHook() {
        return new FabricTickHook.Server();
    }

    @Override
    public TickReporter createTickReporter() {
        return new FabricTickReporter.Server();
    }

    @Override
    public ClassSourceLookup createClassSourceLookup() {
        return new FabricClassSourceLookup(this.createClassFinder());
    }

    @Override
    public Collection<SourceMetadata> getKnownSources() {
        return SourceMetadata.gather(FabricLoader.getInstance().getAllMods(), mod -> mod.getMetadata().getId(), mod -> mod.getMetadata().getVersion().getFriendlyString(), mod -> mod.getMetadata().getAuthors().stream().map(Person::getName).collect(Collectors.joining(", ")), mod -> mod.getMetadata().getDescription());
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new FabricWorldInfoProvider.Server(this.server);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new FabricPlatformInfo(PlatformInfo.Type.SERVER);
    }
}

