/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import java.util.function.IntConsumer;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ScrollbarWidget
extends AbstractWidget {
    private static final int COLOR = ColorABGR.pack(50, 50, 50, 150);
    private static final int HIGHLIGHT_COLOR = ColorABGR.pack(100, 100, 100, 150);
    private final boolean horizontal;
    private final boolean alwaysShow;
    private int visible;
    private int total;
    private int scrollAmount;
    private long lastScrollTime;
    private boolean dragging;
    private final IntConsumer onScrollChange;

    public ScrollbarWidget(Dim2i dim2i, IntConsumer onScrollChange) {
        this(dim2i, false, false, onScrollChange);
    }

    public ScrollbarWidget(Dim2i dim2i, boolean horizontal, boolean alwaysShow) {
        this(dim2i, horizontal, alwaysShow, null);
    }

    public ScrollbarWidget(Dim2i dim2i, boolean horizontal, boolean alwaysShow, IntConsumer onScrollChange) {
        super(dim2i);
        this.horizontal = horizontal;
        this.alwaysShow = alwaysShow;
        this.onScrollChange = onScrollChange;
    }

    public void setScrollbarContext(int visible, int total) {
        this.visible = visible;
        this.total = total;
        this.setScrollAndNotify(Math.max(0, Math.min(total - visible, this.scrollAmount)));
    }

    public void setScrollbarContext(int total) {
        this.setScrollbarContext(this.horizontal ? this.getWidth() : this.getHeight(), total);
    }

    public boolean canScroll() {
        return this.total > this.visible;
    }

    public void scroll(int amount) {
        this.scrollTo(this.scrollAmount + amount);
    }

    public void scrollTo(int target) {
        if (this.setScrollAndNotify(Math.max(0, Math.min(this.total - this.visible, target)))) {
            this.lastScrollTime = System.currentTimeMillis();
        }
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    private boolean setScrollAndNotify(int newScrollAmount) {
        if (newScrollAmount != this.scrollAmount) {
            this.scrollAmount = newScrollAmount;
            if (this.onScrollChange != null) {
                this.onScrollChange.accept(this.scrollAmount);
            }
            return true;
        }
        return false;
    }

    public void method_25394(@NonNull class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!this.canScroll()) {
            return;
        }
        boolean isMouseOver = this.method_25405(mouseX, mouseY);
        if (isMouseOver) {
            this.lastScrollTime = Math.max(this.lastScrollTime, System.currentTimeMillis() - 500L);
        }
        long time = System.currentTimeMillis();
        long scrollTimeDiff = time - this.lastScrollTime;
        if (this.alwaysShow || isMouseOver || this.dragging || scrollTimeDiff < 1000L) {
            int y2;
            int x2;
            int y1;
            int x1;
            graphics.method_25294(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), COLOR);
            if (this.horizontal) {
                x1 = this.getX() + this.getHighlightStart(this.getWidth());
                y1 = this.getY();
                x2 = x1 + this.getHighlightLength(this.getWidth());
                y2 = y1 + this.getHeight();
            } else {
                x1 = this.getX();
                y1 = this.getY() + this.getHighlightStart(this.getHeight());
                x2 = x1 + this.getWidth();
                y2 = y1 + this.getHighlightLength(this.getHeight());
            }
            graphics.method_25294(x1, y1, x2, y2, HIGHLIGHT_COLOR);
        }
    }

    private boolean isMouseOverHighlight(double mouseX, double mouseY) {
        int y2;
        int x2;
        int y1;
        int x1;
        if (this.horizontal) {
            x1 = this.getX() + this.getHighlightStart(this.getWidth());
            y1 = this.getY();
            x2 = x1 + this.getHighlightLength(this.getWidth());
            y2 = y1 + this.getHeight();
        } else {
            x1 = this.getX();
            y1 = this.getY() + this.getHighlightStart(this.getHeight());
            x2 = x1 + this.getWidth();
            y2 = y1 + this.getHighlightLength(this.getHeight());
        }
        return mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2;
    }

    private int getHighlightStart(int length) {
        return (int)Math.round((double)this.scrollAmount / (double)this.total * (double)length);
    }

    private int getHighlightLength(int length) {
        return (int)Math.round((double)this.visible / (double)this.total * (double)length);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!this.method_25405(event.comp_4798(), event.comp_4799()) || !this.canScroll()) {
            return false;
        }
        if (this.isMouseOverHighlight(event.comp_4798(), event.comp_4799())) {
            this.dragging = true;
        } else if (this.horizontal) {
            this.scroll(event.comp_4798() > (double)this.getHighlightStart(this.getWidth()) ? this.getWidth() : -this.getWidth());
        } else {
            this.scroll(event.comp_4799() > (double)this.getHighlightStart(this.getHeight()) ? this.getHeight() : -this.getHeight());
        }
        return true;
    }

    public boolean method_25406(class_11909 event) {
        this.dragging = false;
        this.lastScrollTime = Math.max(this.lastScrollTime, System.currentTimeMillis() - 500L);
        return false;
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (this.dragging) {
            this.scroll((int)Math.round(this.horizontal ? deltaX : deltaY * ((double)this.total / (double)this.visible)));
            return true;
        }
        return false;
    }

    @Override
    public void method_37020(class_6382 builder) {
    }

    @Override
    public @Nullable class_8016 method_48205(class_8023 event) {
        return null;
    }
}

