/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import net.caffeinemc.mods.sodium.api.config.option.Range;
import net.caffeinemc.mods.sodium.client.config.structure.IntegerOption;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.StatefulOption;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.caffeinemc.mods.sodium.client.gui.options.control.AbstractOptionList;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.apache.commons.lang3.Validate;

public class SliderControl
implements Control {
    private final IntegerOption option;

    public SliderControl(IntegerOption option, int min, int max, int interval) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisible by the interval", (Object[])new Object[0]);
        this.option = option;
    }

    @Override
    public ControlElement createElement(class_437 screen, AbstractOptionList list, Dim2i dim, ColorTheme theme) {
        return new SliderControlElement(list, this.option, dim, theme);
    }

    @Override
    public StatefulOption<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        throw new UnsupportedOperationException("Not implemented");
    }

    static class SliderControlElement
    extends ControlElement {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final IntegerOption option;
        private double thumbPosition;
        private boolean sliderHeld;
        private int contentWidth;

        public SliderControlElement(AbstractOptionList list, IntegerOption option, Dim2i dim, ColorTheme theme) {
            super(list, dim, theme);
            this.option = option;
            this.thumbPosition = this.getThumbPositionForValue((Integer)option.getValidatedValue());
            this.sliderHeld = false;
        }

        @Override
        public Option getOption() {
            return this.option;
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            int sliderX = this.getSliderX();
            int sliderY = this.getSliderY();
            int sliderWidth = this.getSliderWidth();
            int sliderHeight = this.getSliderHeight();
            Integer value = (Integer)this.option.getValidatedValue();
            boolean isEnabled = this.option.isEnabled();
            class_2561 label = this.option.formatValue(value);
            if (!isEnabled) {
                label = this.formatDisabledControlValue(label);
            }
            int labelWidth = this.font.method_27525((class_5348)label);
            boolean drawSlider = isEnabled && (this.hovered || this.method_25370());
            this.contentWidth = drawSlider ? sliderWidth + labelWidth : labelWidth;
            super.method_25394(graphics, mouseX, mouseY, delta);
            if (drawSlider) {
                this.thumbPosition = this.getThumbPositionForValue(value);
                Range range = this.option.getRange();
                double thumbOffset = class_3532.method_15350((double)((double)(this.getIntValue() - range.min()) / (double)range.getSpread() * (double)sliderWidth), (double)0.0, (double)sliderWidth);
                int thumbX = (int)((double)sliderX + thumbOffset - 2.0);
                int trackY = (int)((double)((float)sliderY + (float)sliderHeight / 2.0f) - 0.5);
                this.drawRect(graphics, sliderX, trackY, sliderX + sliderWidth, trackY + 1, this.theme.themeLighter);
                this.drawRect(graphics, thumbX, sliderY, thumbX + 4, sliderY + sliderHeight, -1);
                this.drawString(graphics, label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 + -4, -1);
            } else {
                this.drawString(graphics, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 + -4, -1);
            }
        }

        public int getSliderX() {
            return this.getLimitX() - 96;
        }

        public int getSliderY() {
            return this.getCenterY() - 5;
        }

        public int getSliderWidth() {
            return 90;
        }

        public int getSliderHeight() {
            return 10;
        }

        public boolean isMouseOverSlider(double mouseX, double mouseY) {
            return mouseX >= (double)this.getSliderX() && mouseX < (double)(this.getSliderX() + this.getSliderWidth()) && mouseY >= (double)this.getSliderY() && mouseY < (double)(this.getSliderY() + this.getSliderHeight());
        }

        @Override
        public int getContentWidth() {
            return this.contentWidth;
        }

        public int getIntValue() {
            Range range = this.option.getRange();
            return range.min() + range.step() * (int)Math.round(this.thumbPosition / (1.0 / (double)range.getSpread()) / (double)range.step());
        }

        public double getThumbPositionForValue(int value) {
            Range range = this.option.getRange();
            return (double)(value - range.min()) * (1.0 / (double)range.getSpread());
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            this.sliderHeld = false;
            if (this.option.isEnabled() && event.method_74245() == 0 && this.method_25405(event.comp_4798(), event.comp_4799())) {
                if (this.isMouseOverSlider(event.comp_4798(), event.comp_4799())) {
                    this.setValueFromMouse(event.comp_4798());
                    this.sliderHeld = true;
                }
                return true;
            }
            return false;
        }

        public boolean method_25406(class_11909 event) {
            if (this.option.isEnabled() && event.method_74245() == 0 && this.sliderHeld) {
                this.sliderHeld = false;
                this.playClickSound();
                return true;
            }
            return false;
        }

        public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
            if (this.option.isEnabled() && event.method_74245() == 0) {
                if (this.sliderHeld) {
                    this.setValueFromMouse(event.comp_4798());
                }
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.getSliderX()) / (double)this.getSliderWidth());
        }

        public void setValue(double d) {
            this.thumbPosition = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValidatedValue() != value) {
                this.option.modifyValue(value);
            }
        }

        public boolean method_25404(class_11908 event) {
            if (!this.method_25370()) {
                return false;
            }
            Range range = this.option.getRange();
            if (event.method_74232()) {
                this.option.modifyValue(class_3532.method_15340((int)((Integer)this.option.getValidatedValue() - range.step()), (int)range.max(), (int)range.max()));
                return true;
            }
            if (event.method_74233()) {
                this.option.modifyValue(class_3532.method_15340((int)((Integer)this.option.getValidatedValue() + range.step()), (int)range.min(), (int)range.max()));
                return true;
            }
            return false;
        }
    }
}

