/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_9801;

public class OverlayRendererHandheldBeaconRange
extends OverlayRendererBase {
    public static final OverlayRendererHandheldBeaconRange INSTANCE = new OverlayRendererHandheldBeaconRange();
    private boolean needsUpdate;
    protected int updateDistance = 2;
    private int level = -1;
    private class_238 box;
    private boolean hasData;

    protected OverlayRendererHandheldBeaconRange() {
        this.useCulling = true;
        this.renderThrough = false;
        this.box = null;
        this.hasData = false;
    }

    @Override
    public String getName() {
        return "Handheld Beacon Range";
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        if (mc.field_1724 == null) {
            return false;
        }
        class_1792 item = mc.field_1724.method_6047().method_7909();
        if (RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue()) {
            return item instanceof class_1747 && ((class_1747)item).method_7711() == class_2246.field_10327;
        }
        return false;
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)this.updateDistance || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)this.updateDistance || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)this.updateDistance;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        if (RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue()) {
            this.calculateBeaconBoxForPlayer(entity.method_73183(), entity, mc);
            if (this.hasData()) {
                this.render(cameraPos, mc, profiler);
            }
        }
    }

    @Override
    public boolean hasData() {
        return this.hasData && this.level > 0 && this.level < 5 && this.box != null;
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("held_beacon_quads");
        Color4f color = OverlayRendererBeaconRange.getColorForLevel(this.level);
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:held_beacon/quads", MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1);
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        RenderUtils.drawBoxAllSidesBatchedQuads(this.box, Color4f.fromColor((int)color.intValue, (float)0.3f), builder);
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererHandheldBeaconRange#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrices.method_22909();
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("held_beacon_outlines");
        Color4f color = OverlayRendererBeaconRange.getColorForLevel(this.level);
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:held_beacon/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        RenderUtils.drawBoxAllEdgesBatchedLines(this.box, Color4f.fromColor((int)color.intValue, (float)1.0f), this.glLineWidth, builder);
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererHandheldBeaconRange#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.level = -1;
        this.box = null;
        this.hasData = false;
    }

    private void calculateBeaconBoxForPlayer(class_1937 world, class_1297 entity, class_310 mc) {
        if (mc.field_1724 == null) {
            return;
        }
        class_243 cameraPos = mc.field_1773.method_19418().method_71156();
        double x = Math.floor(entity.method_23317()) - cameraPos.field_1352;
        double y = Math.floor(entity.method_23318()) - cameraPos.field_1351;
        double z = Math.floor(entity.method_23321()) - cameraPos.field_1350;
        this.level = mc.field_1724.method_5715() ? Math.min(4, mc.field_1724.method_31548().method_67532() + 1) : 4;
        float range = this.level * 10 + 10;
        float minX = (float)(x - (double)range);
        float minY = (float)(y - (double)range);
        float minZ = (float)(z - (double)range);
        float maxX = (float)(x + (double)range + 1.0);
        float maxY = (float)(y + (double)range + 24.0);
        float maxZ = (float)(z + (double)range + 1.0);
        this.box = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        this.hasData = true;
    }
}

