/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtInventory;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.DebugDataManager;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineChunkCache;
import fi.dy.masa.minihud.renderer.InventoryOverlayHandler;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.SpeedUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_276;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4481;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_5455;
import net.minecraft.class_5537;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final class_310 mc;
    private final DataStorage data;
    private final HudDataManager hudData;
    private final Date date;
    private final Set<InfoToggle> addedTypes = new HashSet<InfoToggle>();
    private long infoUpdateTime;
    private final List<StringHolder> lineWrappers = new ArrayList<StringHolder>();
    private final List<String> lines = new ArrayList<String>();
    private Pair<class_2586, CompoundData> lastBlockEntity = null;
    private Pair<class_1297, CompoundData> lastEntity = null;
    private Pair<class_1297, CompoundData> lastEnderItems = null;

    public RenderHandler() {
        this.mc = class_310.method_1551();
        this.data = DataStorage.getInstance();
        this.hudData = HudDataManager.getInstance();
        this.date = new Date();
    }

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public DataStorage getDataStorage() {
        return this.data;
    }

    public HudDataManager getHudData() {
        return this.hudData;
    }

    public static void fixDebugRendererState() {
    }

    public void onRenderGameOverlayPostAdvanced(GuiContext ctx, float partialTicks, class_3695 profiler) {
        if (!Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue()) {
            InfoLineChunkCache.INSTANCE.onReset();
            return;
        }
        if (!(DebugDataManager.getInstance().shouldShowDebugHudFix() || this.mc.field_1724 == null || this.mc.field_1690.field_1842 || Configs.Generic.REQUIRE_SNEAK.getBooleanValue() && !this.mc.field_1724.method_5715() || !Configs.Generic.REQUIRED_KEY.getKeybind().isKeybindHeld())) {
            long currentTime = System.nanoTime();
            if (currentTime - this.infoUpdateTime >= 50000000L) {
                this.updateLines();
                this.infoUpdateTime = currentTime;
            }
            int x = Configs.Generic.TEXT_POS_X.getIntegerValue();
            int y = Configs.Generic.TEXT_POS_Y.getIntegerValue();
            int textColor = Configs.Colors.TEXT_COLOR.getIntegerValue();
            int bgColor = Configs.Colors.TEXT_BACKGROUND_COLOR.getIntegerValue();
            HudAlignment alignment = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
            boolean useBackground = Configs.Generic.USE_TEXT_BACKGROUND.getBooleanValue();
            boolean useShadow = Configs.Generic.USE_FONT_SHADOW.getBooleanValue();
            RenderUtils.renderText((GuiContext)ctx, (int)x, (int)y, (double)Configs.Generic.FONT_SCALE.getDoubleValue(), (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, (boolean)Configs.Generic.HUD_STATUS_EFFECTS_SHIFT.getBooleanValue(), this.lines);
        }
        if (Configs.Generic.INVENTORY_PREVIEW_ENABLED.getBooleanValue() && Configs.Generic.INVENTORY_PREVIEW.getKeybind().isKeybindHeld()) {
            InventoryOverlayHandler.getInstance().getRenderContext(ctx, profiler);
        }
    }

    public void onRenderWorldPreWeather(class_276 fb, Matrix4f posMatrix, Matrix4f projMatrix, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
    }

    public void onRenderWorldLastAdvanced(class_276 fb, Matrix4f posMatrix, Matrix4f projMatrix, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        if (Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && this.mc.field_1687 != null && this.mc.field_1724 != null && !this.mc.field_1690.field_1842) {
            OverlayRenderer.renderOverlays(posMatrix, projMatrix, this.mc, frustum, camera, profiler);
        }
    }

    public void onRenderTooltipLast(GuiContext ctx, class_1799 stack, int x, int y) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1806) {
            if (Configs.Generic.MAP_PREVIEW.getBooleanValue() && (!Configs.Generic.MAP_PREVIEW_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderMapPreview((GuiContext)ctx, (class_1799)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue(), (boolean)false);
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49622) && InventoryUtils.shulkerBoxHasItems((class_1799)stack)) {
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderShulkerBoxPreview((GuiContext)ctx, (class_1799)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
        } else if (stack.method_31574(class_1802.field_8466) && Configs.Generic.SHULKER_DISPLAY_ENDER_CHEST.getBooleanValue()) {
            class_1937 world;
            class_1657 player;
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown()) && (player = (world = WorldUtils.getBestWorld((class_310)this.mc)).method_18470(this.mc.field_1724.method_5667())) != null) {
                class_1730 inv;
                Pair<class_1297, CompoundData> pair = EntitiesDataManager.getInstance().requestEntity(world, player.method_5628());
                if (pair != null && pair.getRight() != null && ((CompoundData)pair.getRight()).contains("EnderItems", 9)) {
                    inv = InventoryUtils.getPlayerEnderItemsFromData((CompoundData)((CompoundData)pair.getRight()), (class_5455)world.method_30349());
                    this.lastEnderItems = pair;
                } else {
                    class_1657 pe;
                    Object object;
                    inv = pair != null && (object = pair.getLeft()) instanceof class_1657 && !(pe = (class_1657)object).method_7274().method_5442() ? pe.method_7274() : (this.lastEnderItems != null ? InventoryUtils.getPlayerEnderItemsFromData((CompoundData)((CompoundData)this.lastEnderItems.getRight()), (class_5455)world.method_30349()) : player.method_7274());
                }
                if (inv != null) {
                    try (NbtInventory nbtInv = NbtInventory.fromInventory((class_1263)inv);){
                        class_2487 nbt = new class_2487();
                        class_2499 list = nbtInv.toNbtList(world.method_30349());
                        nbt.method_10566("EnderItems", (class_2520)list);
                        RenderUtils.renderNbtItemsPreview((GuiContext)ctx, (class_1799)stack, (class_2487)nbt, (int)x, (int)y, (boolean)false);
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49650) && InventoryUtils.bundleHasItems((class_1799)stack) && Configs.Generic.BUNDLE_PREVIEW.getBooleanValue() && (!Configs.Generic.BUNDLE_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
            RenderUtils.renderBundlePreview((GuiContext)ctx, (class_1799)stack, (int)x, (int)y, (int)Configs.Generic.BUNDLE_DISPLAY_ROW_WIDTH.getIntegerValue(), (boolean)Configs.Generic.BUNDLE_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
        }
    }

    public Supplier<String> getProfilerSectionSupplier() {
        return () -> "minihud_renderer";
    }

    public void onRenderTooltipComponentInsertFirst(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
    }

    public void onRenderTooltipComponentInsertMiddle(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (Configs.Generic.BUNDLE_TOOLTIPS.getBooleanValue() && stack.method_7909() instanceof class_5537) {
            MiscUtils.addBundleTooltip(stack, list);
        }
    }

    public void onRenderTooltipComponentInsertLast(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        class_1747 blockItem;
        class_1792 class_17922;
        if (Configs.Generic.AXOLOTL_TOOLTIPS.getBooleanValue() && stack.method_7909() == class_1802.field_28354) {
            MiscUtils.addAxolotlTooltip(stack, list);
        }
        if (Configs.Generic.BEE_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49624)) {
            MiscUtils.addBeeTooltip(stack, list);
        }
        if (Configs.Generic.CUSTOM_MODEL_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49637)) {
            MiscUtils.addCustomModelTooltip(stack, list);
        }
        if (Configs.Generic.FOOD_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_50075)) {
            MiscUtils.addFoodTooltip(stack, list);
        }
        if (Configs.Generic.HONEY_TOOLTIPS.getBooleanValue() && (class_17922 = stack.method_7909()) instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_4481) {
            MiscUtils.addHoneyTooltip(stack, list);
        }
        if (Configs.Generic.LODESTONE_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49614)) {
            MiscUtils.addLodestoneTooltip(stack, list);
        }
    }

    public int getSubtitleOffset() {
        if (Configs.Generic.OFFSET_SUBTITLE_HUD.getBooleanValue() && Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && Configs.Generic.HUD_ALIGNMENT.getOptionListValue() == HudAlignment.BOTTOM_RIGHT) {
            int offset = (int)((double)(this.lineWrappers.size() * (StringUtils.getFontHeight() + 2)) * Configs.Generic.FONT_SCALE.getDoubleValue());
            return -(offset - 16);
        }
        return 0;
    }

    public void updateData(class_310 mc) {
        if (mc.field_1687 != null && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            DataStorage.getInstance().updateStructureData();
        }
    }

    private void updateLines() {
        this.lineWrappers.clear();
        this.addedTypes.clear();
        InfoLineChunkCache.INSTANCE.onUpdate();
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (InfoToggle toggle : InfoToggle.values()) {
            if (!toggle.getBooleanValue()) continue;
            positions.add(new LinePos(toggle.getIntegerValue(), toggle));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            try {
                this.addLine(pos.type);
            }
            catch (Exception e) {
                this.addLine(pos.type.getName() + ": exception");
            }
        }
        if (Configs.Generic.SORT_LINES_BY_LENGTH.getBooleanValue()) {
            Collections.sort(this.lineWrappers);
            if (Configs.Generic.SORT_LINES_REVERSED.getBooleanValue()) {
                Collections.reverse(this.lineWrappers);
            }
        }
        this.lines.clear();
        for (StringHolder holder : this.lineWrappers) {
            this.lines.add(holder.str);
        }
    }

    private void processEntries(List<InfoLine.Entry> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (InfoLine.Entry entry : list) {
            if (entry.isEmpty()) continue;
            if (entry.isTranslated()) {
                this.addLine(entry.format());
                continue;
            }
            if (entry.hasArgs()) {
                this.addLineI18n(entry.format(), entry.args());
                continue;
            }
            this.addLineI18n(entry.format(), new Object[0]);
        }
    }

    public void addLine(String text) {
        this.lineWrappers.add(new StringHolder(this, text));
    }

    public void addLineI18n(String translatedName, Object ... args) {
        this.addLine(StringUtils.translate((String)translatedName, (Object[])args));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addLine(InfoToggle type) {
        class_310 mc = this.mc;
        class_1297 entity = mc.method_1560();
        if (entity == null) return;
        class_1937 class_19372 = entity.method_73183();
        class_1937 world = class_19372;
        if (world == null) return;
        if (mc.field_1687 == null) {
            return;
        }
        double y = entity.method_23318();
        class_2338 pos = class_2338.method_49637((double)entity.method_23317(), (double)y, (double)entity.method_23321());
        class_1923 chunkPos = new class_1923(pos);
        boolean isChunkLoaded = mc.field_1687.method_22340(pos);
        SpeedUnits speedUnits = (SpeedUnits)Configs.Generic.SPEED_UNITS.getOptionListValue();
        if (!isChunkLoaded) {
            return;
        }
        if (type == InfoToggle.FPS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.GPU) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.MEMORY_USAGE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.TIME_REAL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.TIME_WORLD) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.TIME_WORLD_FORMATTED) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.TIME_DAY_MODULO) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.TIME_TOTAL_MODULO) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.SERVER_TPS) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.SERVUX) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.WEATHER) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.MOB_CAPS) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PING) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, (class_1297)mc.field_1724, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.COORDINATES || type == InfoToggle.COORDINATES_SCALED || type == InfoToggle.DIMENSION) {
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES)) return;
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES_SCALED)) return;
            if (this.addedTypes.contains((Object)InfoToggle.DIMENSION)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            String fmtStr = Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue();
            double x = entity.method_23317();
            double z = entity.method_23321();
            if (InfoToggle.COORDINATES.getBooleanValue()) {
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                    }
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                }
                pre = " / ";
            }
            if (InfoToggle.COORDINATES_SCALED.getBooleanValue() && (world.method_27983() == class_1937.field_25180 || world.method_27983() == class_1937.field_25179)) {
                boolean isNether = world.method_27983() == class_1937.field_25180;
                double scale = isNether ? 8.0 : 0.125;
                x *= scale;
                z *= scale;
                str.append(pre);
                if (isNether) {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.overworld", (Object[])new Object[0]));
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.nether", (Object[])new Object[0]));
                }
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                    }
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                }
                pre = " / ";
            }
            if (InfoToggle.DIMENSION.getBooleanValue()) {
                String dimName = world.method_27983().method_29177().toString();
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.dimension", (Object[])new Object[0])).append(dimName);
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.COORDINATES);
            this.addedTypes.add(InfoToggle.COORDINATES_SCALED);
            this.addedTypes.add(InfoToggle.DIMENSION);
            return;
        } else if (type == InfoToggle.BLOCK_POS || type == InfoToggle.CHUNK_POS || type == InfoToggle.REGION_FILE) {
            if (this.addedTypes.contains((Object)InfoToggle.BLOCK_POS)) return;
            if (this.addedTypes.contains((Object)InfoToggle.CHUNK_POS)) return;
            if (this.addedTypes.contains((Object)InfoToggle.REGION_FILE)) {
                return;
            }
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, chunkPos, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.BLOCK_IN_CHUNK) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, pos, null, chunkPos, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.BLOCK_BREAK_SPEED) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.SPRINTING) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.DISTANCE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, entity, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.FACING) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, entity, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LIGHT_LEVEL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, chunkPos, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.BEE_COUNT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_2586, CompoundData> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (class_2586)pair.getLeft(), null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.COMPARATOR_OUTPUT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_2586, CompoundData> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (class_2586)pair.getLeft(), null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.HONEY_LEVEL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_2680 state = this.getTargetedBlock(mc);
            if (state == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, state, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.FURNACE_XP) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_2586, CompoundData> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (class_2586)pair.getLeft(), null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.HORSE_SPEED || type == InfoToggle.HORSE_JUMP || type == InfoToggle.HORSE_MAX_HEALTH) {
            InfoLine.Context ctx;
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(bestWorld, mc);
            if (mc.field_1724.method_5765() && pair == null) {
                ctx = new InfoLine.Context(bestWorld, mc.field_1724.method_5854(), null, null, null, null, null);
            } else {
                if (pair == null) return;
                ctx = new InfoLine.Context(bestWorld, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            }
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ROTATION_YAW || type == InfoToggle.ROTATION_PITCH || type == InfoToggle.SPEED) {
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_YAW)) return;
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_PITCH)) return;
            if (this.addedTypes.contains((Object)InfoToggle.SPEED)) {
                return;
            }
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, entity, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.SPEED_HV) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, entity, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.SPEED_AXIS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, entity, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.CHUNK_SECTIONS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.CHUNK_SECTIONS_FULL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.CHUNK_UPDATES) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LOADED_CHUNKS_COUNT) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PANDA_GENE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PARTICLE_COUNT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.DIFFICULTY) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.BIOME) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, chunkPos, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.BIOME_REG_NAME) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, chunkPos, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.ENTITIES) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.TILE_ENTITIES) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.ENTITIES_CLIENT_WORLD) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(WorldUtils.getBestWorld((class_310)mc), null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.SLIME_CHUNK) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LOOKING_AT_ENTITY) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_VARIANT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_HOME_POS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_COPPER_AGING) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.LOOKING_AT_EFFECTS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ZOMBIE_CONVERSION) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.DOLPHIN_TREASURE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_REG_NAME) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PLAYER_EXPERIENCE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            if (mc.field_1724 == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, (class_1297)mc.field_1724, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LOOKING_AT_PLAYER_EXP) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, CompoundData> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, null, (CompoundData)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.LOOKING_AT_BLOCK || type == InfoToggle.LOOKING_AT_BLOCK_CHUNK) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_2680 state = this.getTargetedBlock(mc);
            if (state == null) return;
            class_2338 lookPos = ((class_3965)mc.field_1765).method_17777();
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, lookPos, state, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else {
            if (type != InfoToggle.BLOCK_PROPS) return;
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_2680 state = this.getTargetedBlock(mc);
            if (state == null) return;
            class_2338 lookPos = ((class_3965)mc.field_1765).method_17777();
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, lookPos, state, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
        }
    }

    private boolean isEntityDataValid(@Nonnull CompoundData data) {
        if (InventoryUtils.hasDataItems((CompoundData)data)) {
            return true;
        }
        Iterator iterator = data.getKeys().iterator();
        block28: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Fire": {
                    int fire;
                    int n = fire = data.contains("Fire", 2) ? (int)data.getShort("Fire") : -1;
                    if (fire >= 0 && fire <= 0) continue block28;
                    return true;
                }
                case "Age": {
                    int age;
                    int n = age = data.contains("Age", 3) ? data.getInt("Age") : -1;
                    if (age != 0 && age <= 1) continue block28;
                    return true;
                }
                case "Brain": {
                    CompoundData tag = data.getCompound("Brain");
                    if (tag.isEmpty() || tag.getCompound("memories").isEmpty()) continue block28;
                    return true;
                }
                case "Offers": {
                    return true;
                }
                case "Recipes": {
                    return true;
                }
                case "ConversionTime": {
                    if (data.getInt("ConversionTime") <= 0) break;
                    return true;
                }
                case "DrownedConversionTime": {
                    if (data.getInt("DrownedConversionTime") <= 0) break;
                    return true;
                }
                case "StrayConversionTime": {
                    if (data.getInt("StrayConversionTime") <= 0) break;
                    return true;
                }
                case "ConversionPlayer": {
                    return true;
                }
                case "recipeBook": {
                    return true;
                }
                case "recipes": {
                    return true;
                }
                case "active_effects": {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public Pair<class_1297, CompoundData> getTargetEntity(class_1937 world, class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1331) {
            class_1297 lookedEntity = ((class_3966)mc.field_1765).method_17782();
            if (lookedEntity == null || lookedEntity.method_5628() == mc.field_1724.method_5628()) {
                return null;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_1297, CompoundData> pair = null;
            if (bestWorld instanceof class_3218) {
                class_3218 serverWorld = (class_3218)bestWorld;
                class_1297 serverEntity = serverWorld.method_8469(lookedEntity.method_5628());
                CompoundData data = DataEntityUtils.invokeEntityDataTagNoPassengers((class_1297)serverEntity, (int)lookedEntity.method_5628());
                if (!data.isEmpty()) {
                    pair = Pair.of((Object)serverEntity, (Object)data);
                }
            } else {
                pair = EntitiesDataManager.getInstance().requestEntity(world, lookedEntity.method_5628());
            }
            if (pair == null && this.lastEntity != null && ((class_1297)this.lastEntity.getLeft()).method_5628() == lookedEntity.method_5628()) {
                pair = this.lastEntity;
            } else if (pair != null && pair.getRight() != null && !((CompoundData)pair.getRight()).isEmpty() && this.isEntityDataValid((CompoundData)pair.getRight())) {
                this.lastEntity = pair;
            } else if (this.lastEntity != null && ((class_1297)this.lastEntity.getLeft()).method_5628() == lookedEntity.method_5628()) {
                pair = this.lastEntity;
            }
            return pair;
        }
        return null;
    }

    @Nullable
    public Pair<class_2586, CompoundData> getTargetedBlockEntity(class_1937 world, class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            class_2680 state = bestWorld.method_8320(posLooking);
            Pair<class_2586, CompoundData> pair = null;
            if (state.method_26204() instanceof class_2343) {
                if (bestWorld instanceof class_3218) {
                    class_2586 be;
                    CompoundData data = new CompoundData();
                    pair = Pair.of((Object)be, (Object)((be = bestWorld.method_8500(posLooking).method_8321(posLooking)) != null ? DataConverterNbt.fromVanillaCompound((class_2487)be.method_38242((class_7225.class_7874)bestWorld.method_30349())) : data));
                } else {
                    pair = EntitiesDataManager.getInstance().requestBlockEntity(world, posLooking);
                }
                if (pair == null && this.lastBlockEntity != null && ((class_2586)this.lastBlockEntity.getLeft()).method_11016().equals((Object)posLooking)) {
                    pair = this.lastBlockEntity;
                } else if (pair != null) {
                    this.lastBlockEntity = pair;
                }
                return pair;
            }
        }
        return null;
    }

    @Nullable
    public Pair<class_2586, CompoundData> requestBlockEntityAt(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            class_2745 type;
            Pair<class_2586, CompoundData> pair = EntitiesDataManager.getInstance().requestBlockEntity(world, pos);
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof class_2281 && (type = (class_2745)state.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569) {
                return EntitiesDataManager.getInstance().requestBlockEntity(world, pos.method_10093(class_2281.method_9758((class_2680)state)));
            }
            return pair;
        }
        return null;
    }

    @Nullable
    private class_2680 getTargetedBlock(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            return mc.field_1687.method_8320(posLooking);
        }
        return null;
    }

    private <T extends Comparable<T>> void getBlockProperties(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_2680 state = mc.field_1687.method_8320(posLooking);
            class_2960 rl = class_7923.field_41175.method_10221((Object)state.method_26204());
            this.addLine(rl != null ? rl.toString() : "<null>");
            for (String line : BlockUtils.getFormattedBlockStateProperties((class_2680)state)) {
                this.addLine(line);
            }
        }
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final InfoToggle type;

        private LinePos(int position, InfoToggle type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(@Nonnull LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(RenderHandler renderHandler, String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

