/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.render.postprocess;

import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.ResourcePacksReloadedEvent;
import meteordevelopment.meteorclient.renderer.MeshRenderer;
import meteordevelopment.meteorclient.renderer.Texture;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.Chams;
import meteordevelopment.meteorclient.utils.PostInit;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.postprocess.EntityShader;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_11280;
import net.minecraft.class_1297;
import net.minecraft.class_3298;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public class ChamsShader
extends EntityShader {
    private static final String[] FILE_FORMATS = new String[]{"png", "jpg"};
    private static Texture IMAGE_TEX;
    private static Chams chams;
    private static final int UNIFORM_SIZE;
    private static final class_11280<UniformData> UNIFORM_STORAGE;

    public ChamsShader() {
        MeteorClient.EVENT_BUS.subscribe(ChamsShader.class);
    }

    @PostInit
    public static void load() {
        try {
            ByteBuffer data = null;
            for (String fileFormat : FILE_FORMATS) {
                Optional optional = MeteorClient.mc.method_1478().method_14486(MeteorClient.identifier("textures/chams." + fileFormat));
                if (optional.isEmpty() || ((class_3298)optional.get()).method_14482() == null) continue;
                data = TextureUtil.readResource((InputStream)((class_3298)optional.get()).method_14482());
                break;
            }
            if (data == null) {
                return;
            }
            data.rewind();
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer width = stack.mallocInt(1);
                IntBuffer height = stack.mallocInt(1);
                IntBuffer comp = stack.mallocInt(1);
                STBImage.stbi_set_flip_vertically_on_load((boolean)true);
                ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)data, (IntBuffer)width, (IntBuffer)height, (IntBuffer)comp, (int)4);
                IMAGE_TEX = new Texture(width.get(0), height.get(0), TextureFormat.RGBA8, FilterMode.NEAREST, FilterMode.NEAREST);
                IMAGE_TEX.upload(image);
                STBImage.stbi_image_free((ByteBuffer)image);
                STBImage.stbi_set_flip_vertically_on_load((boolean)false);
            }
        }
        catch (IOException e) {
            MeteorClient.LOG.error("Error loading the chams shader", (Throwable)e);
        }
    }

    @EventHandler
    private static void onResourcePacksReloaded(ResourcePacksReloadedEvent event) {
        ChamsShader.load();
    }

    @Override
    protected void setupPass(MeshRenderer renderer) {
        Color color = ChamsShader.chams.shaderColor.get();
        renderer.uniform("ImageData", UNIFORM_STORAGE.method_71102((class_11280.class_11281)new UniformData((float)color.r / 255.0f, (float)color.g / 255.0f, (float)color.b / 255.0f, (float)color.a / 255.0f)));
        if (chams.isShader() && ChamsShader.chams.shader.get() == Chams.Shader.Image && IMAGE_TEX != null) {
            renderer.sampler("u_TextureI", IMAGE_TEX.method_71659(), IMAGE_TEX.method_75484());
        }
    }

    @Override
    protected boolean shouldDraw() {
        if (chams == null) {
            chams = Modules.get().get(Chams.class);
        }
        return chams.isShader();
    }

    @Override
    public boolean shouldDraw(class_1297 entity) {
        if (!this.shouldDraw()) {
            return false;
        }
        return ChamsShader.chams.entities.get().contains(entity.method_5864()) && (entity != MeteorClient.mc.field_1724 || ChamsShader.chams.ignoreSelfDepth.get() == false);
    }

    public static void flipFrame() {
        UNIFORM_STORAGE.method_71100();
    }

    static {
        UNIFORM_SIZE = new Std140SizeCalculator().putVec4().get();
        UNIFORM_STORAGE = new class_11280("Meteor - Image UBO", UNIFORM_SIZE, 16);
    }

    private record UniformData(float r, float g, float b, float a) implements class_11280.class_11281
    {
        public void method_71104(ByteBuffer buffer) {
            Std140Builder.intoBuffer((ByteBuffer)buffer).putVec4(this.r, this.g, this.b, this.a);
        }
    }
}

