/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options.table.type;

import com.google.gson.JsonObject;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.options.table.type.Entry;
import fi.dy.masa.malilib.config.options.table.type.EntryTypes;

public class DoubleEntry
extends Entry {
    private double value;

    public DoubleEntry(double value) {
        this.value = value;
    }

    public static DoubleEntry of(double val) {
        return new DoubleEntry(val);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public EntryTypes getType() {
        return EntryTypes.DOUBLE;
    }

    @Override
    public JsonObject getAsJsonObject() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", "double");
        obj.addProperty("value", String.valueOf(this.value));
        return obj;
    }

    @Override
    public Entry copy() {
        return new DoubleEntry(this.value);
    }

    @Override
    public boolean wasConfigModified(Entry entry) {
        if (!(entry instanceof DoubleEntry)) {
            return true;
        }
        DoubleEntry other = (DoubleEntry)entry;
        return this.value != other.value;
    }

    @Override
    public String asString() {
        return Double.toString(this.getValue());
    }

    public static DoubleEntry getFromJsonObject(JsonObject obj) {
        try {
            double val = Double.parseDouble(obj.get("value").getAsString());
            return DoubleEntry.of(val);
        }
        catch (NumberFormatException e) {
            MaLiLib.LOGGER.error("Failed to parse double from JSON object: [{}]; {}", (Object)obj, (Object)e.getLocalizedMessage());
            return DoubleEntry.of(0.0);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleEntry)) {
            return false;
        }
        DoubleEntry other = (DoubleEntry)o;
        return other.getValue() == this.getValue();
    }
}

