/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.poi;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.util.Distances;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.util.collections.ListeningLong2ObjectOpenHashMap;
import net.caffeinemc.mods.lithium.common.util.functions.FunLongAnd5;
import net.caffeinemc.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3977;
import net.minecraft.class_4076;
import net.minecraft.class_4180;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_9820;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4180.class})
public abstract class SectionStorageMixin<R>
implements RegionBasedStorageSectionExtended<R> {
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> field_18692;
    @Shadow
    @Final
    protected class_5539 field_27240;
    private Long2ObjectOpenHashMap<BitSet> columns;

    @Shadow
    protected abstract Optional<R> method_19293(long var1);

    @Shadow
    protected abstract void method_61787(class_1923 var1);

    @Inject(method={"<init>(Lnet/minecraft/class_3977;Lcom/mojang/serialization/Codec;Ljava/util/function/Function;Ljava/util/function/BiFunction;Ljava/util/function/Function;Lnet/minecraft/class_5455;Lnet/minecraft/class_9820;Lnet/minecraft/class_5539;)V"}, at={@At(value="RETURN")})
    private void init(class_3977 simpleRegionStorage, Codec codec, Function function, BiFunction biFunction, Function function2, class_5455 registryAccess, class_9820 chunkIOErrorReporter, class_5539 levelHeightAccessor, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.field_18692 = new ListeningLong2ObjectOpenHashMap<Optional>(this::onEntryAdded, this::onEntryRemoved);
    }

    private void onEntryRemoved(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.field_27240, class_4076.method_18689((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.field_27240)) {
            return;
        }
        int x = class_4076.method_18686((long)key);
        long pos = class_1923.method_8331((int)x, (int)(z = class_4076.method_18690((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags != null) {
            flags.clear(y);
            if (flags.isEmpty()) {
                this.columns.remove(pos);
            }
        }
    }

    private void onEntryAdded(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.field_27240, class_4076.method_18689((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.field_27240)) {
            return;
        }
        int x = class_4076.method_18686((long)key);
        long pos = class_1923.method_8331((int)x, (int)(z = class_4076.method_18690((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags == null) {
            flags = new BitSet(Pos.SectionYIndex.getNumYSections(this.field_27240));
            this.columns.put(pos, (Object)flags);
        }
        flags.set(y, value.isPresent());
    }

    @Override
    public <S, T, U> U lithium$getFirstInRangeInChunkColumn(int chunkX, int chunkZ, long deltaYSqMargin, class_2338 center, long radiusSq, FunLongAnd5<R, class_2338, Predicate<class_6880<S>>, Predicate<class_2338>, T, U> sectionMapper, Predicate<class_6880<S>> predicate, Predicate<class_2338> filter, T status) {
        BitSet sectionsWithPOI = this.lithium$getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return null;
        }
        int minYSection = Pos.SectionYCoord.getMinYSection(this.field_27240);
        int chunkYIndex = sectionsWithPOI.nextSetBit(0);
        while (chunkYIndex != -1) {
            Object r;
            U result;
            int chunkY = chunkYIndex + minYSection;
            long minYDistance = Distances.getClosestBlockCoordInSection(center.method_10264(), chunkY) - center.method_10264();
            if (minYDistance * minYDistance <= deltaYSqMargin && (result = sectionMapper.apply(r = ((Optional)this.field_18692.get(class_4076.method_18685((int)chunkX, (int)chunkY, (int)chunkZ))).orElse(null), center, predicate, filter, status, radiusSq)) != null) {
                return result;
            }
            chunkYIndex = sectionsWithPOI.nextSetBit(chunkYIndex + 1);
        }
        return null;
    }

    @Override
    public Iterable<R> lithium$getInChunkColumn(final int chunkX, final int chunkZ) {
        final BitSet sectionsWithPOI = this.lithium$getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return Collections::emptyIterator;
        }
        final Long2ObjectMap<Optional<R>> loadedElements = this.field_18692;
        final class_5539 world = this.field_27240;
        return () -> new AbstractIterator<R>(this){
            private int nextBit;
            {
                this.nextBit = sectionsWithPOI.nextSetBit(0);
            }

            protected R computeNext() {
                while (this.nextBit >= 0) {
                    Optional next = (Optional)loadedElements.get(class_4076.method_18685((int)chunkX, (int)Pos.SectionYCoord.fromSectionIndex(world, this.nextBit), (int)chunkZ));
                    this.nextBit = sectionsWithPOI.nextSetBit(this.nextBit + 1);
                    if (!next.isPresent()) continue;
                    return next.get();
                }
                return this.endOfData();
            }
        };
    }

    @Override
    public BitSet lithium$getNonEmptyPOISections(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags != null) {
            return flags;
        }
        this.method_61787(new class_1923(pos));
        return Objects.requireNonNull((BitSet)this.columns.get(pos), "Failed to load POI section data!");
    }

    @Override
    public Optional<R> lithium$getElementAt(long sectionPos) {
        return (Optional)this.field_18692.get(sectionPos);
    }

    @Override
    public int lithium$getChunkYMin() {
        return Pos.SectionYCoord.getMinYSection(this.field_27240);
    }

    @Override
    public int lithium$getChunkYMaxInclusive() {
        return Pos.SectionYCoord.getMaxYSectionInclusive(this.field_27240);
    }
}

