/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import fi.dy.masa.litematica.compat.iris.IrisCompat;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import javax.annotation.Nullable;
import net.minecraft.class_11531;
import net.minecraft.class_11658;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_12137;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_776;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private class_310 mc;
    private WorldRendererSchematic worldRenderer;
    private class_4604 frustum;
    private int frameCount;
    private long finishTimeNano;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean renderPiecewiseEntities;
    private boolean renderPiecewiseTileEntities;

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    private LitematicaRenderer() {
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = class_310.method_1551();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public WorldRendererSchematic resetWorldRenderer() {
        if (this.worldRenderer != null) {
            this.worldRenderer.setWorldAndLoadRenderers(null);
            this.worldRenderer = null;
        }
        return this.getWorldRenderer();
    }

    public void loadRenderers(@Nullable class_3695 profiler) {
        this.getWorldRenderer().loadRenderers(profiler);
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    public void onBlockModelRendererReload(class_776 manager) {
        if (this.worldRenderer != null) {
            this.worldRenderer.reloadBlockRenderManager(manager);
        }
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + 1000000000L / fpsTarget / 2L;
    }

    public void renderSchematicOverlays(class_4184 camera, class_3695 profiler) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            profiler.method_15396("schematic_overlay");
            if (!IrisCompat.isShadowPassActive()) {
                this.getWorldRenderer().renderBlockOverlays(camera, lineWidth, profiler);
            }
            profiler.method_15407();
        }
    }

    public void updateCameraState(class_4184 camera, float tickProgress) {
        this.getWorldRenderer().updateCameraState(camera, tickProgress);
    }

    public void piecewisePrepareAndUpdate(class_4604 frustum, class_3695 profiler) {
        boolean render = Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.method_1560() != null;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        this.renderPiecewiseEntities = false;
        this.renderPiecewiseTileEntities = false;
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        if (render && frustum != null && worldRenderer.hasWorld() && this.mc.field_1724 != null) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderPiecewiseEntities = this.renderPiecewiseSchematic && Configs.Visuals.RENDER_SCHEMATIC_ENTITIES.getBooleanValue();
            boolean bl = this.renderPiecewiseTileEntities = this.renderPiecewiseSchematic && Configs.Visuals.RENDER_SCHEMATIC_TILE_ENTITIES.getBooleanValue();
            if (this.renderPiecewiseSchematic) {
                profiler.method_15396("litematica_culling");
                this.calculateFinishTime();
                profiler.method_15405("litematica_terrain_setup");
                worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.field_1724.method_7325(), profiler);
                profiler.method_15405("litematica_update_chunks");
                worldRenderer.updateChunks(this.finishTimeNano, profiler);
                profiler.method_15407();
                this.frustum = frustum;
            }
        }
    }

    public void scheduleTranslucentSorting(class_243 camera, class_3695 profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.method_15396("litematica_schedule_translucent_sorting");
            this.getWorldRenderer().scheduleTranslucentSorting(camera, profiler);
            profiler.method_15407();
        }
    }

    public void capturePreMainValues(class_4184 camera, GpuBufferSlice fogBuffer, class_3695 profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.method_15396("litematica_pre_main_capture");
            this.getWorldRenderer().capturePreMainValues(camera, fogBuffer, profiler);
            profiler.method_15407();
        }
    }

    public void piecewisePrepareBlockLayers(Matrix4fc matrix4fc, double cameraX, double cameraY, double cameraZ, class_3695 profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.method_15396("litematica_prepare_block_layers");
            this.getWorldRenderer().prepareBlockLayers(matrix4fc, cameraX, cameraY, cameraZ, profiler);
            profiler.method_15407();
        }
    }

    public void piecewiseDrawBlockLayerGroup(class_11531 group, @Nullable class_12137 sampler) {
        if (this.renderPiecewiseBlocks) {
            this.getWorldRenderer().drawBlockLayerGroup(group, sampler);
        }
    }

    public void piecewisePrepareEntities(class_4184 camera, class_4604 frustum, class_11658 renderStates, class_9779 tickCounter, class_3695 profiler) {
        if (this.renderPiecewiseEntities) {
            profiler.method_15396("litematica_prepare_entities");
            this.getWorldRenderer().prepareEntities(this.getCamera(), this.frustum, renderStates, tickCounter, profiler);
            profiler.method_15407();
        }
    }

    public void piecewiseRenderEntities(class_4587 matrices, class_11658 renderStates, class_11659 queue, class_3695 profiler) {
        if (this.renderPiecewiseEntities) {
            profiler.method_15396("litematica_render_entities");
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, matrices, renderStates, queue, profiler);
            profiler.method_15407();
        }
    }

    public void piecewisePrepareBlockEntities(class_4184 camera, class_4604 frustum, class_11658 renderStates, float tickProgress, class_3695 profiler) {
        if (this.renderPiecewiseTileEntities) {
            profiler.method_15396("litematica_prepare_block_entities");
            class_4587 matrices = new class_4587();
            this.getWorldRenderer().prepareBlockEntities(this.getCamera(), this.frustum, renderStates, matrices, tickProgress, profiler);
            profiler.method_15407();
        }
    }

    public void piecewiseRenderBlockEntities(class_4587 matrices, class_11658 renderStates, class_11661 queue, class_3695 profiler) {
        if (this.renderPiecewiseTileEntities) {
            profiler.method_15396("litematica_block_entities");
            this.getWorldRenderer().renderBlockEntities(this.getCamera(), this.frustum, matrices, renderStates, (class_11659)queue, profiler);
            profiler.method_15407();
        }
    }

    public void piecewiseRenderOverlay(Matrix4f posMatrix, Matrix4f projMatrix, class_3695 profiler) {
        if (this.renderPiecewiseSchematic) {
            profiler.method_15396("litematica_schematic_overlay");
            this.renderSchematicOverlays(this.getCamera(), profiler);
            profiler.method_15407();
        }
        this.getWorldRenderer().clearBlockBatchDraw();
        this.getWorldRenderer().clearWorldRenderStates();
        this.cleanup();
    }

    private class_4184 getCamera() {
        return this.mc.field_1773.method_19418();
    }

    private void cleanup() {
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        this.renderPiecewiseEntities = false;
        this.renderPiecewiseTileEntities = false;
    }
}

