/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.compat.iris;

import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.irisshaders.iris.api.v0.IrisApi;

public class IrisCompat {
    private static final String SODIUM_ID = "sodium";
    private static final String IRIS_ID = "iris";
    private static boolean isSodiumLoaded = false;
    private static boolean isIrisLoaded = false;
    private static String sodiumVersion = "";
    private static String irisVersion = "";

    public static boolean hasIris() {
        return isSodiumLoaded && isIrisLoaded;
    }

    public static boolean isShaderActive() {
        if (IrisCompat.hasIris()) {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean isShadowPassActive() {
        if (IrisCompat.hasIris()) {
            return IrisApi.getInstance().isRenderingShadowPass();
        }
        return false;
    }

    public static void registerPipelines() {
        if (IrisCompat.hasIris()) {
            // empty if block
        }
    }

    static {
        FabricLoader.getInstance().getAllMods().stream().toList().forEach(mc -> {
            ModMetadata meta = mc.getMetadata();
            if (Objects.equals(meta.getId(), SODIUM_ID)) {
                sodiumVersion = meta.getVersion().getFriendlyString();
                isSodiumLoaded = true;
            } else if (Objects.equals(meta.getId(), IRIS_ID)) {
                irisVersion = meta.getVersion().getFriendlyString();
                isIrisLoaded = true;
            }
        });
    }
}

