/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import dlovin.inventoryhud.gui.widgets.TextField;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_310;
import net.minecraft.class_327;

public class NumericTextField
extends TextField {
    private final int minValue;
    private final int maxValue;
    private final int defValue;

    public NumericTextField(class_327 font, int x, int y, int width, int height, int minValue, int maxValue, int defValue, TextField.IPressable onChange) {
        super(font, x, y, width, height, "" + defValue, onChange);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defValue = defValue;
    }

    @Override
    public void writeText(String textToWrite) {
        Object s1;
        int l;
        int i;
        block7: {
            String s;
            i = Math.min(this.cursorPosition, this.selectionEnd);
            int j = Math.max(this.cursorPosition, this.selectionEnd);
            int k = this.maxStringLength - this.text.length() - (i - j);
            if (k < (l = (s = textToWrite).length())) {
                s = s.substring(0, k);
                l = k;
            }
            s1 = new StringBuilder(this.text).replace(i, j, s).toString();
            try {
                int num = Integer.parseInt((String)s1);
                s1 = "" + num;
                if (num < this.minValue) {
                    s1 = "" + this.minValue;
                } else if (num > this.maxValue) {
                    s1 = "" + this.maxValue;
                }
            }
            catch (NumberFormatException ex) {
                if (s.equalsIgnoreCase("-")) break block7;
                s1 = this.prevText;
            }
        }
        if (this.validator.test(s1)) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        if (!newText.equals(this.prevText) && this.isNumeric(newText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (this.canWrite() && keyEvent.method_74243()) {
            if (this.isNumeric(class_310.method_1551().field_1774.method_1460())) {
                this.writeText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    public boolean method_25400(class_11905 event) {
        if (!this.canWrite()) {
            return false;
        }
        if (this.isNumeric(event.method_74226())) {
            this.writeText(event.method_74226());
            return true;
        }
        if (event.comp_4793() == 45) {
            if (!this.getText().contains("-") && this.cursorPosition == 0) {
                this.writeText(event.method_74226());
            }
            return true;
        }
        return false;
    }

    @Override
    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.isShiftDown = false;
            this.setCursorPosition(0);
            if (!this.isNumeric(this.text) || this.text.equals("")) {
                this.setText("" + this.defValue);
            }
        }
    }

    private boolean isNumeric(String text) {
        if (text == null) {
            return false;
        }
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }
}

