/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.utils.ArmorStatus;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class HotBarArmorRenderer
extends ArmorRenderer {
    private final int[] armorPosX = new int[]{-96, -96, 96, 96, 96, -96};
    private final int[] armorPosY = new int[]{56, 38, 56, 38, 74, 74, 20, 20};

    public HotBarArmorRenderer(class_310 mc) {
        super(mc);
    }

    @Override
    public void render(class_332 gui, int width, int height) {
        int seed = 40;
        int iconOff = (int)(-16.0f * this.armScale);
        boolean hr = this.mc.field_1724.method_6068().equals((Object)class_1306.field_6183);
        boolean emptyOff = this.mc.field_1724.method_6079().method_7960();
        Object[] leftX = this.getLeftX(width, this.armScale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        Object[] rightX = this.getRightX(width, this.armScale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        Object[] leftXScaled = (Object[])leftX.clone();
        Object[] rightXScaled = (Object[])rightX.clone();
        if (this.armScale >= 1.0f) {
            leftXScaled[0] = width / 2 + iconOff;
            rightXScaled[0] = width / 2;
            if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                leftXScaled[0] = (int)((float)((Integer)leftXScaled[0]).intValue() - 24.0f * this.armScale);
                rightXScaled[0] = (int)((float)((Integer)rightXScaled[0]).intValue() + 24.0f * this.armScale);
            }
            leftXScaled[1] = !this.armView.equals((Object)InvConfig.ArmorView.OFF);
            rightXScaled[1] = this.armView.equals((Object)InvConfig.ArmorView.OFF);
        }
        this.preRender(gui, 0, 0);
        if (this.showMain) {
            seed = this.renderSlot(gui, (Integer)leftXScaled[0] + this.armorPosX[5], (int)((float)height - (float)(this.armorPosY[5] - (this.showArmor ? 0 : 36)) * this.armScale), (Boolean)leftXScaled[1], this.mc.field_1724.method_6047(), 5, seed);
        }
        if (this.showOff) {
            seed = this.renderSlot(gui, (Integer)rightXScaled[0] + this.armorPosX[4], (int)((float)height - (float)(this.armorPosY[4] - (this.showArmor ? 0 : 36)) * this.armScale), (Boolean)rightXScaled[1], this.mc.field_1724.method_6079(), 4, seed);
        }
        if (this.showArmor) {
            seed = this.renderSlot(gui, (Integer)rightXScaled[0] + this.armorPosX[3], (int)((float)height - (float)this.armorPosY[3] * this.armScale), (Boolean)rightXScaled[1], this.mc.field_1724.method_6118(class_1304.field_6166), 3, seed);
            seed = this.renderSlot(gui, (Integer)rightXScaled[0] + this.armorPosX[2], (int)((float)height - (float)this.armorPosY[2] * this.armScale), (Boolean)rightXScaled[1], this.mc.field_1724.method_6118(class_1304.field_6172), 2, seed);
            seed = this.renderSlot(gui, (Integer)leftXScaled[0] + this.armorPosX[1], (int)((float)height - (float)this.armorPosY[1] * this.armScale), (Boolean)leftXScaled[1], this.mc.field_1724.method_6118(class_1304.field_6174), 1, seed);
            this.renderSlot(gui, (Integer)leftXScaled[0] + this.armorPosX[0], (int)((float)height - (float)this.armorPosY[0] * this.armScale), (Boolean)leftXScaled[1], this.mc.field_1724.method_6118(class_1304.field_6169), 0, seed);
        }
        if (this.showInv || this.showArrows) {
            int[] values = this.getFreeAndAmmo();
            if (this.showArrows()) {
                this.pushAndRender(gui, (Integer)leftX[0], (int)((float)height - (float)this.armorPosY[7] * this.armScale), (Boolean)leftX[1], this.armorRL[7], null, "" + values[1], false, this.armScale, 0);
            }
            if (this.showInv) {
                this.pushAndRender(gui, (Integer)rightX[0], (int)((float)height - (float)this.armorPosY[7] * this.armScale), (Boolean)rightX[1], this.armorRL[6], null, "" + values[0], false, this.armScale, 0);
            }
        }
        this.postRender(gui);
    }

    private int renderSlot(class_332 gui, int xOffset, int yOffset, boolean right, class_1799 item, int index, int seed) {
        int damage = ArmorStatus.getDamage(item);
        if (damage >= 0 && damage <= this.armAbove) {
            String text = this.getText(item, damage);
            this.pushAndRender(gui, xOffset, yOffset, right, null, item, text, this.armBars, this.armScale, seed++);
        } else if (damage == -2) {
            boolean over = true;
            String text = null;
            if ((index == 5 || index == 4) && this.showCount) {
                text = String.valueOf(this.getItemCount(item));
                over = false;
            }
            this.pushAndRender(gui, xOffset, yOffset, right, null, item, text, over, this.armScale, seed++);
        } else if (this.showEmpty) {
            this.pushAndRender(gui, xOffset, yOffset, right, this.armorRL[index], null, null, false, this.armScale, 0);
        }
        return seed;
    }

    private Object[] getRightX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int offset = !avOff || !empty && !hRight ? (!empty && !hRight && scale < 1.0f ? 26 : (int)(24.0f * scale)) : 0;
        boolean right = avOff || !hRight && !empty;
        return new Object[]{width / 2 + 96 + offset, right};
    }

    private Object[] getLeftX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int iconOffset = (int)(-16.0f * scale);
        int offset = !avOff || !empty && hRight ? (!empty && hRight && scale < 1.0f ? -26 : (int)(-24.0f * scale)) : 0;
        boolean right = !avOff && (!hRight || empty);
        return new Object[]{width / 2 - 96 + iconOffset + offset, right};
    }

    private void pushAndRender(class_332 gui, int x, int y, boolean right, class_2960 resourceLocation, class_1799 itemStack, String text, boolean over, float scale, int seed) {
        gui.method_51448().pushMatrix();
        gui.method_51448().translate((float)x, (float)y);
        gui.method_51448().scale(scale, scale);
        this.renderElement(gui, right, resourceLocation, itemStack, text, over, seed);
        gui.method_51448().popMatrix();
    }
}

