/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.init;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.AutoConfigClient;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.class_1269;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.FallingLeavesConfig;
import randommcsomethin.fallingleaves.config.FallingLeavesConfigV0;
import randommcsomethin.fallingleaves.config.FallingLeavesConfigV1;
import randommcsomethin.fallingleaves.config.gson.GsonConfigHelper;
import randommcsomethin.fallingleaves.config.gson.IdentifierTypeAdapter;
import randommcsomethin.fallingleaves.config.gson.LeafSettingsTypeAdapter;
import randommcsomethin.fallingleaves.config.gui.IdentifierGuiProvider;
import randommcsomethin.fallingleaves.config.gui.LeafSettingsGuiProvider;
import randommcsomethin.fallingleaves.config.gui.StringSetGuiProvider;
import randommcsomethin.fallingleaves.util.Wind;

public class Config {
    public static FallingLeavesConfig CONFIG;
    public static final Gson GSON;
    private static ConfigHolder<FallingLeavesConfig> configHolder;

    public static void init() {
        Config.migrateConfigV0toV1();
        Config.migrateConfigV1toV2();
        configHolder = AutoConfig.register(FallingLeavesConfig.class, (definition, configClass) -> new GsonConfigSerializer(definition, configClass, GSON));
        CONFIG = (FallingLeavesConfig)configHolder.getConfig();
        configHolder.registerSaveListener((manager, data) -> {
            try {
                data.validatePostLoad();
            }
            catch (ConfigData.ValidationException validationException) {
                // empty catch block
            }
            Wind.init();
            return class_1269.field_5812;
        });
        if (Config.CONFIG.displayDebugData && FallingLeavesClient.LOGGER.getLevel().compareTo(Level.DEBUG) < 0) {
            Configurator.setLevel((String)FallingLeavesClient.LOGGER.getName(), (Level)Level.DEBUG);
        }
        AutoConfigClient.getGuiRegistry(FallingLeavesConfig.class).registerPredicateProvider((GuiProvider)new LeafSettingsGuiProvider(), field -> field.getName().equals("leafSettings"));
        for (StringSetGuiProvider<String> guiProvider : List.of(new StringSetGuiProvider<class_2960>(class_2960.class, class_2960::method_60654), new StringSetGuiProvider<String>(String.class, s -> s))) {
            AutoConfigClient.getGuiRegistry(FallingLeavesConfig.class).registerPredicateProvider(guiProvider, guiProvider.getPredicate());
        }
        AutoConfigClient.getGuiRegistry(FallingLeavesConfig.class).registerTypeProvider((GuiProvider)new IdentifierGuiProvider(), new Class[]{class_2960.class});
        FallingLeavesClient.LOGGER.debug("Loaded configuration.");
    }

    public static void save() {
        configHolder.save();
    }

    private static void migrateConfigV1toV2() {
        FallingLeavesConfigV1 oldConfig;
        GsonConfigHelper newGsonHelper = new GsonConfigHelper("fallingleaves2", GSON);
        GsonConfigHelper oldGsonHelper = new GsonConfigHelper("fallingleaves", GSON);
        if (newGsonHelper.exists() || !oldGsonHelper.exists()) {
            return;
        }
        try {
            oldConfig = oldGsonHelper.load(FallingLeavesConfigV1.class);
        }
        catch (JsonParseException | IOException e) {
            FallingLeavesClient.LOGGER.debug("Couldn't load config as v1?!");
            return;
        }
        FallingLeavesClient.LOGGER.info("Migrating v1 config (fallingleaves.json) to v2 (fallingleaves2.json)");
        FallingLeavesConfig newConfig = new FallingLeavesConfig();
        newConfig.displayDebugData = oldConfig.displayDebugData;
        newConfig.enabled = oldConfig.enabled;
        newConfig.leafSize = oldConfig.leafSize;
        newConfig.leafLifespan = oldConfig.leafLifespan;
        newConfig.dropFromPlayerPlacedBlocks = oldConfig.dropFromPlayerPlacedBlocks;
        newConfig.leavesOnBlockHit = oldConfig.leavesOnBlockHit;
        newConfig.minimumFreeSpaceBelow = oldConfig.minimumFreeSpaceBelow;
        newConfig.windEnabled = oldConfig.windEnabled;
        newConfig.windlessDimensions = oldConfig.windlessDimensions;
        oldConfig.leafSettings.forEach((id, oldEntry) -> newConfig.updateLeafSettings((class_2960)id, newEntry -> {
            newEntry.isConiferBlock = oldEntry.isConiferBlock;
            newEntry.spawnBreakingLeaves = oldEntry.spawnBreakingLeaves;
        }));
        newConfig.leafSpawners = oldConfig.leafSpawners;
        newConfig.fallSpawnRateFactor = (float)oldConfig.fallSpawnRateFactor;
        newConfig.winterSpawnRateFactor = (float)oldConfig.winterSpawnRateFactor;
        newConfig.startingSpawnRadius = oldConfig.startingSpawnRadius;
        newConfig.decaySpawnRateFactor = (float)oldConfig.decaySpawnRateFactor;
        newConfig.maxDecayLeaves = oldConfig.maxDecayLeaves;
        newConfig.registerParticles = oldConfig.registerParticles;
        try {
            newConfig.validatePostLoad();
            newGsonHelper.save(newConfig);
            FallingLeavesClient.LOGGER.info("Migrated to v2 successfully");
        }
        catch (JsonIOException | IOException e) {
            FallingLeavesClient.LOGGER.error("Couldn't save migrated config!", e);
        }
        catch (ConfigData.ValidationException e) {
            FallingLeavesClient.LOGGER.error("Couldn't validate new config!", (Throwable)e);
        }
    }

    private static void migrateConfigV0toV1() {
        FallingLeavesConfigV0 oldConfig;
        GsonConfigHelper gsonHelper = new GsonConfigHelper("fallingleaves", GSON);
        if (!gsonHelper.exists()) {
            return;
        }
        try {
            oldConfig = gsonHelper.load(FallingLeavesConfigV0.class);
        }
        catch (JsonParseException | IOException e) {
            FallingLeavesClient.LOGGER.debug("Couldn't load config as v0, assuming it is v1");
            return;
        }
        if (oldConfig.version != 0) {
            return;
        }
        FallingLeavesClient.LOGGER.info("Migrating v0 config to v1");
        FallingLeavesConfigV1 newConfig = new FallingLeavesConfigV1();
        newConfig.setLeafSize(oldConfig.leafSize);
        newConfig.leafLifespan = oldConfig.leafLifespan;
        newConfig.setLeafSpawnRate(oldConfig.leafRate);
        newConfig.setConiferLeafSpawnRate(oldConfig.coniferLeafRate);
        for (String string : oldConfig.coniferLeafIds) {
            newConfig.updateLeafSettings(class_2960.method_60654((String)string), entry -> {
                entry.isConiferBlock = true;
            });
        }
        for (Map.Entry entry2 : oldConfig.rateOverrides.entrySet()) {
            newConfig.updateLeafSettings(class_2960.method_60654((String)((String)entry2.getKey())), newEntry -> {
                double oldRateOverride = (Double)oldEntry.getValue();
                if (newEntry.isConiferBlock) {
                    if (oldConfig.coniferLeafRate != 0.0) {
                        newEntry.spawnRateFactor = oldRateOverride / oldConfig.coniferLeafRate;
                    }
                } else if (oldConfig.leafRate != 0.0) {
                    newEntry.spawnRateFactor = oldRateOverride / oldConfig.leafRate;
                }
            });
        }
        try {
            gsonHelper.save(newConfig);
            FallingLeavesClient.LOGGER.info("Migrated to v1 successfully");
        }
        catch (JsonIOException | IOException e) {
            FallingLeavesClient.LOGGER.error("Couldn't save migrated config!", e);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(class_2960.class, (Object)IdentifierTypeAdapter.INST).registerTypeAdapterFactory((TypeAdapterFactory)new LeafSettingsTypeAdapter()).create();
    }
}

