/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.services;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.forge.services.ForgeRegisterItemHelper;
import com.natamus.collective_common_forge.services.helpers.RegisterBlockHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegisterBlockHelper
implements RegisterBlockHelper {
    private static final HashMap<String, DeferredRegister<Block>> deferredBlockRegisterMap = new HashMap();
    private static final HashMap<Identifier, RegistryObject<Block>> registeredBlocksWithoutItem = new HashMap();
    private static final HashMap<Identifier, Pair<RegistryObject<Block>, RegistryObject<Item>>> registeredBlockWithItemPairs = new HashMap();

    @Override
    public <T extends Block> void registerBlockWithoutItem(Object modEventBusObject, Identifier Identifier2, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, boolean lastBlock) {
        ForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, Identifier2, blockFunction, properties, null, lastBlock, false);
    }

    @Override
    public Block getRegisteredBlockWithoutItem(Identifier Identifier2) {
        return (Block)registeredBlocksWithoutItem.get(Identifier2).get();
    }

    @Override
    public <T extends Block> void registerBlockWithItem(Object modEventBusObject, Identifier Identifier2, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock) {
        ForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, Identifier2, blockFunction, properties, creativeModeTabResourceKey, lastBlock, true);
    }

    @Override
    public Block getRegisteredBlockWithItem(Identifier Identifier2) {
        return (Block)((RegistryObject)registeredBlockWithItemPairs.get(Identifier2).getFirst()).get();
    }

    @Override
    public Pair<Block, BlockItem> getRegisteredBlockWithItemPair(Identifier Identifier2) {
        Pair<RegistryObject<Block>, RegistryObject<Item>> deferredPair = registeredBlockWithItemPairs.get(Identifier2);
        return Pair.of((Object)((Block)((RegistryObject)deferredPair.getFirst()).get()), (Object)((BlockItem)((RegistryObject)deferredPair.getSecond()).get()));
    }

    @Override
    public void setRegisteredBlockWithItemPair(Identifier Identifier2, Class<?> blockClass, String blockFieldName, Class<?> blockItemClass, String blockItemFieldName) {
        Pair<RegistryObject<Block>, RegistryObject<Item>> deferredPair = registeredBlockWithItemPairs.get(Identifier2);
        try {
            Field blockField = blockClass.getDeclaredField(blockFieldName);
            blockField.setAccessible(true);
            blockField.set(null, ((RegistryObject)deferredPair.getFirst()).get());
            Field blockItemField = blockItemClass.getDeclaredField(blockItemFieldName);
            blockItemField.setAccessible(true);
            blockItemField.set(null, ((RegistryObject)deferredPair.getSecond()).get());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static <T extends Block> void staticRegisterBlock(Object modEventBusObject, Identifier Identifier2, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock, boolean registerAsItem) {
        String namespace = Identifier2.getNamespace();
        if (!deferredBlockRegisterMap.containsKey(namespace)) {
            DeferredRegister deferredBlockRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)namespace);
            deferredBlockRegisterMap.put(namespace, (DeferredRegister<Block>)deferredBlockRegister);
        }
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier2);
        Supplier<Block> blockSupplier = () -> (Block)blockFunction.apply(properties.setId(resourceKey));
        RegistryObject deferredBlockObject = deferredBlockRegisterMap.get(namespace).register(Identifier2.getPath(), blockSupplier);
        if (registerAsItem) {
            RegistryObject<Item> deferredItemObject = ForgeRegisterItemHelper.staticRegisterItem(modEventBusObject, Identifier2, itemProperties -> new BlockItem((Block)deferredBlockObject.get(), itemProperties), new Item.Properties().useBlockDescriptionPrefix(), creativeModeTabResourceKey, lastBlock);
            registeredBlockWithItemPairs.put(Identifier2, (Pair<RegistryObject<Block>, RegistryObject<Item>>)Pair.of((Object)deferredBlockObject, deferredItemObject));
        } else {
            registeredBlocksWithoutItem.put(Identifier2, (RegistryObject<Block>)deferredBlockObject);
        }
        if (lastBlock) {
            deferredBlockRegisterMap.get(namespace).register((BusGroup)modEventBusObject);
        }
    }
}

