/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.seedfinding.mcbiome.biome.Biome;
import com.seedfinding.mcbiome.biome.Biomes;
import com.seedfinding.mccore.util.data.Pair;
import com.seedfinding.mccore.version.MCVersion;
import com.seedfinding.mcfeature.loot.effect.Effect;
import com.seedfinding.mcfeature.loot.effect.Effects;
import com.seedfinding.mcfeature.loot.item.Item;
import com.seedfinding.mcfeature.loot.item.ItemStack;
import java.util.Objects;
import net.earthcomputer.clientcommands.util.MultiVersionCompat;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

public class SeedfindingUtil {
    private static final BiMap<class_5321<class_1887>, String> SEEDFINDING_ENCHANTMENTS = (BiMap)class_156.method_654((Object)HashBiMap.create(), map -> {
        map.put((Object)class_1893.field_9111, (Object)"protection");
        map.put((Object)class_1893.field_9095, (Object)"fire_protection");
        map.put((Object)class_1893.field_9129, (Object)"feather_falling");
        map.put((Object)class_1893.field_9107, (Object)"blast_protection");
        map.put((Object)class_1893.field_9096, (Object)"projectile_protection");
        map.put((Object)class_1893.field_9127, (Object)"respiration");
        map.put((Object)class_1893.field_9105, (Object)"aqua_affinity");
        map.put((Object)class_1893.field_9097, (Object)"thorns");
        map.put((Object)class_1893.field_9128, (Object)"depth_strider");
        map.put((Object)class_1893.field_9122, (Object)"frost_walker");
        map.put((Object)class_1893.field_9113, (Object)"binding_curse");
        map.put((Object)class_1893.field_23071, (Object)"soul_speed");
        map.put((Object)class_1893.field_9118, (Object)"sharpness");
        map.put((Object)class_1893.field_9123, (Object)"smite");
        map.put((Object)class_1893.field_9112, (Object)"bane_of_arthropods");
        map.put((Object)class_1893.field_9121, (Object)"knockback");
        map.put((Object)class_1893.field_9124, (Object)"fire_aspect");
        map.put((Object)class_1893.field_9110, (Object)"looting");
        map.put((Object)class_1893.field_9115, (Object)"sweeping");
        map.put((Object)class_1893.field_9131, (Object)"efficiency");
        map.put((Object)class_1893.field_9099, (Object)"silk_touch");
        map.put((Object)class_1893.field_9119, (Object)"unbreaking");
        map.put((Object)class_1893.field_9130, (Object)"fortune");
        map.put((Object)class_1893.field_9103, (Object)"power");
        map.put((Object)class_1893.field_9116, (Object)"punch");
        map.put((Object)class_1893.field_9126, (Object)"flame");
        map.put((Object)class_1893.field_9125, (Object)"infinity");
        map.put((Object)class_1893.field_9114, (Object)"luck_of_the_sea");
        map.put((Object)class_1893.field_9100, (Object)"lure");
        map.put((Object)class_1893.field_9120, (Object)"loyalty");
        map.put((Object)class_1893.field_9106, (Object)"impaling");
        map.put((Object)class_1893.field_9104, (Object)"riptide");
        map.put((Object)class_1893.field_9117, (Object)"channeling");
        map.put((Object)class_1893.field_9108, (Object)"multishot");
        map.put((Object)class_1893.field_9098, (Object)"quick_charge");
        map.put((Object)class_1893.field_9132, (Object)"piercing");
        map.put((Object)class_1893.field_9101, (Object)"mending");
        map.put((Object)class_1893.field_9109, (Object)"vanishing_curse");
    });
    private static final BiMap<class_6880<class_1291>, Effect> SEEDFINDING_EFFECTS = (BiMap)class_156.method_654((Object)HashBiMap.create(), map -> {
        map.put((Object)class_1294.field_5904, (Object)Effects.MOVEMENT_SPEED);
        map.put((Object)class_1294.field_5909, (Object)Effects.MOVEMENT_SLOWDOWN);
        map.put((Object)class_1294.field_5917, (Object)Effects.DIG_SPEED);
        map.put((Object)class_1294.field_5901, (Object)Effects.DIG_SLOWDOWN);
        map.put((Object)class_1294.field_5910, (Object)Effects.DAMAGE_BOOST);
        map.put((Object)class_1294.field_5915, (Object)Effects.HEAL);
        map.put((Object)class_1294.field_5921, (Object)Effects.HARM);
        map.put((Object)class_1294.field_5913, (Object)Effects.JUMP);
        map.put((Object)class_1294.field_5916, (Object)Effects.CONFUSION);
        map.put((Object)class_1294.field_5924, (Object)Effects.REGENERATION);
        map.put((Object)class_1294.field_5907, (Object)Effects.DAMAGE_RESISTANCE);
        map.put((Object)class_1294.field_5918, (Object)Effects.FIRE_RESISTANCE);
        map.put((Object)class_1294.field_5923, (Object)Effects.WATER_BREATHING);
        map.put((Object)class_1294.field_5905, (Object)Effects.INVISIBILITY);
        map.put((Object)class_1294.field_5919, (Object)Effects.BLINDNESS);
        map.put((Object)class_1294.field_5925, (Object)Effects.NIGHT_VISION);
        map.put((Object)class_1294.field_5903, (Object)Effects.HUNGER);
        map.put((Object)class_1294.field_5911, (Object)Effects.WEAKNESS);
        map.put((Object)class_1294.field_5899, (Object)Effects.POISON);
        map.put((Object)class_1294.field_5920, (Object)Effects.WITHER);
        map.put((Object)class_1294.field_5914, (Object)Effects.HEALTH_BOOST);
        map.put((Object)class_1294.field_5898, (Object)Effects.ABSORPTION);
        map.put((Object)class_1294.field_5922, (Object)Effects.SATURATION);
        map.put((Object)class_1294.field_5912, (Object)Effects.GLOWING);
        map.put((Object)class_1294.field_5902, (Object)Effects.LEVITATION);
        map.put((Object)class_1294.field_5926, (Object)Effects.LUCK);
        map.put((Object)class_1294.field_5908, (Object)Effects.UNLUCK);
        map.put((Object)class_1294.field_5906, (Object)Effects.SLOW_FALLING);
        map.put((Object)class_1294.field_5927, (Object)Effects.CONDUIT_POWER);
        map.put((Object)class_1294.field_5900, (Object)Effects.DOLPHINS_GRACE);
        map.put((Object)class_1294.field_16595, (Object)Effects.BAD_OMEN);
    });

    private SeedfindingUtil() {
    }

    public static @Nullable Biome toSeedfindingBiome(class_1937 level, class_6880<class_1959> biome) {
        class_2960 name = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)biome.comp_349()));
        if (name == null || !"minecraft".equals(name.method_12836())) {
            return null;
        }
        for (Biome b : Biomes.REGISTRY.values()) {
            if (!name.method_12832().equals(b.getName())) continue;
            return b;
        }
        return null;
    }

    public static class_1799 fromSeedfindingItem(Item item, class_5455 registryAccess) {
        return SeedfindingUtil.fromSeedfindingItem(new ItemStack(item), registryAccess);
    }

    public static class_1799 fromSeedfindingItem(ItemStack stack, class_5455 registryAccess) {
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60656((String)stack.getItem().getName()));
        if (!stack.getItem().getEnchantments().isEmpty() && item == class_1802.field_8529) {
            item = class_1802.field_8598;
        }
        class_2378 enchantmentRegistry = registryAccess.method_30530(class_7924.field_41265);
        class_1799 ret = new class_1799((class_1935)item, stack.getCount());
        for (Pair<String, Integer> pair : stack.getItem().getEnchantments()) {
            class_5321 enchKey = Objects.requireNonNull((class_5321)SEEDFINDING_ENCHANTMENTS.inverse().get((Object)pair.getFirst()), () -> "missing seedfinding enchantment " + (String)enchAndLevel.getFirst());
            enchantmentRegistry.method_46746(enchKey).ifPresent(enchantment -> ret.method_7978((class_6880)enchantment, ((Integer)enchAndLevel.getSecond()).intValue()));
        }
        for (Pair<Object, Integer> pair : stack.getItem().getEffects()) {
            class_6880 effectHolder = Objects.requireNonNull((class_6880)SEEDFINDING_EFFECTS.inverse().get(pair.getFirst()), () -> "missing seedfinding effect " + String.valueOf(effectAndDuration.getFirst()));
            class_9298.class_8751 entry = new class_9298.class_8751(effectHolder, pair.getSecond().intValue());
            ret.method_57367(class_9334.field_49652, (Object)class_9298.field_49362, (Object)entry, class_9298::method_57514);
        }
        return ret;
    }

    public static MCVersion getMCVersion() {
        return Objects.requireNonNullElseGet(MCVersion.fromString(MultiVersionCompat.INSTANCE.getProtocolName()), MCVersion::latest);
    }
}

