/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.util;

import com.google.common.collect.Iterables;
import com.mojang.logging.LogUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.slf4j.Logger;

public abstract sealed class MultiVersionCompat {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int V1_7_2 = 4;
    public static final int V1_8 = 47;
    public static final int V1_9 = 107;
    public static final int V1_11 = 315;
    public static final int V1_11_1 = 316;
    public static final int V1_13 = 393;
    public static final int V1_13_2 = 404;
    public static final int V1_14 = 477;
    public static final int V1_14_2 = 485;
    public static final int V1_15 = 573;
    public static final int V1_15_2 = 578;
    public static final int V1_16 = 735;
    public static final int V1_17 = 755;
    public static final int V1_18 = 757;
    public static final int V1_18_2 = 758;
    public static final int V1_20 = 763;
    public static final int V1_20_6 = 766;
    public static final int V1_21 = 767;
    public static final int V1_21_2 = 768;
    public static final int V1_21_9 = 773;
    public static final MultiVersionCompat INSTANCE = (MultiVersionCompat)class_156.method_656(() -> {
        try {
            FabricLoader loader = FabricLoader.getInstance();
            if (loader.isModLoaded("viafabric")) {
                return new ViaFabric();
            }
            if (loader.isModLoaded("viafabricplus")) {
                return new ViaFabricPlus();
            }
            return new None();
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Could not load proper MultiVersionCompat", (Throwable)e);
            return new None();
        }
    });

    public abstract int getProtocolVersion();

    public abstract String getProtocolName();

    public boolean doesItemExist(class_1792 item) {
        return true;
    }

    private static final class ViaFabric
    extends AbstractViaVersion {
        private final Class<?> fabricDecodeHandler = Class.forName("com.viaversion.fabric.common.handler.FabricDecodeHandler");
        private final Field channel;
        private final Method getInfo = this.fabricDecodeHandler.getMethod("getInfo", new Class[0]);
        private final Method getProtocolInfo = this.getInfo.getReturnType().getMethod("getProtocolInfo", new Class[0]);
        private final Method getServerProtocolVersion = this.getProtocolInfo.getReturnType().getMethod("getServerProtocolVersion", new Class[0]);
        private final Method isRegistered = this.protocolVersion.getMethod("isRegistered", Integer.TYPE);
        private final Method getProtocol = this.protocolVersion.getMethod("getProtocol", Integer.TYPE);

        private ViaFabric() throws ReflectiveOperationException {
            Field channelField = null;
            for (Field field : class_2535.class.getDeclaredFields()) {
                if (field.getType() != Channel.class) continue;
                channelField = field;
                channelField.setAccessible(true);
                break;
            }
            if (channelField == null) {
                throw new NoSuchFieldException("Could not find channel field in ClientConnection");
            }
            this.channel = channelField;
        }

        @Override
        public int getProtocolVersion() {
            try {
                return this.doGetProtocolVersion();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Object getCurrentVersion() throws ReflectiveOperationException {
            int protocolVersion = this.doGetProtocolVersion();
            if (!((Boolean)this.isRegistered.invoke(null, protocolVersion)).booleanValue()) {
                protocolVersion = class_155.method_31372();
            }
            return this.getProtocol.invoke(null, protocolVersion);
        }

        private int doGetProtocolVersion() throws ReflectiveOperationException {
            Object user;
            Object protocol;
            Channel channel;
            ChannelHandler viaDecoder;
            int protocolVersion = class_155.method_31372();
            class_634 packetListener = class_310.method_1551().method_1562();
            if (packetListener != null && this.fabricDecodeHandler.isInstance(viaDecoder = (channel = (Channel)this.channel.get(packetListener.method_48296())).pipeline().get("via-decoder")) && (protocol = this.getProtocolInfo.invoke(user = this.getInfo.invoke((Object)viaDecoder, new Object[0]), new Object[0])) != null) {
                protocolVersion = (Integer)this.getServerProtocolVersion.invoke(protocol, new Object[0]);
            }
            return protocolVersion;
        }
    }

    private static final class ViaFabricPlus
    extends AbstractViaVersion {
        private final Method viaFabricPlusGetImpl;
        private final Method getTargetVersion;
        private final Method olderThan;
        private final Method itemExistsInConnection;
        private final Object release1_7_2Version;

        private ViaFabricPlus() throws ReflectiveOperationException {
            Class<?> viaFabricPlus = Class.forName("com.viaversion.viafabricplus.ViaFabricPlus");
            Class<?> viaFabricPlusBase = Class.forName("com.viaversion.viafabricplus.api.ViaFabricPlusBase");
            Class<?> protocolVersion = Class.forName("com.viaversion.viaversion.api.protocol.version.ProtocolVersion");
            this.viaFabricPlusGetImpl = viaFabricPlus.getMethod("getImpl", new Class[0]);
            this.getTargetVersion = viaFabricPlusBase.getMethod("getTargetVersion", new Class[0]);
            this.olderThan = protocolVersion.getMethod("olderThan", protocolVersion);
            this.itemExistsInConnection = viaFabricPlusBase.getMethod("itemExistsInConnection", class_1792.class);
            this.release1_7_2Version = protocolVersion.getField("v1_7_2").get(null);
        }

        @Override
        public int getProtocolVersion() {
            try {
                boolean isOlderThan1_7_2 = (Boolean)this.olderThan.invoke(this.getTargetVersion.invoke(this.getImpl(), new Object[0]), this.release1_7_2Version);
                if (isOlderThan1_7_2) {
                    return 4;
                }
                return super.getProtocolVersion();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Object getCurrentVersion() throws ReflectiveOperationException {
            return this.getTargetVersion.invoke(this.getImpl(), new Object[0]);
        }

        @Override
        public boolean doesItemExist(class_1792 item) {
            try {
                return (Boolean)this.itemExistsInConnection.invoke(this.getImpl(), item);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        private Object getImpl() {
            try {
                return this.viaFabricPlusGetImpl.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class None
    extends MultiVersionCompat {
        private None() {
        }

        @Override
        public int getProtocolVersion() {
            return class_155.method_31372();
        }

        @Override
        public String getProtocolName() {
            return class_155.method_16673().comp_4025();
        }
    }

    private static abstract sealed class AbstractViaVersion
    extends MultiVersionCompat
    permits ViaFabric, ViaFabricPlus {
        protected final Class<?> protocolVersion = Class.forName("com.viaversion.viaversion.api.protocol.version.ProtocolVersion");
        private final Method getVersion = this.protocolVersion.getMethod("getVersion", new Class[0]);
        private final Method getIncludedVersions = this.protocolVersion.getMethod("getIncludedVersions", new Class[0]);

        private AbstractViaVersion() throws ReflectiveOperationException {
        }

        protected abstract Object getCurrentVersion() throws ReflectiveOperationException;

        @Override
        public int getProtocolVersion() {
            try {
                return (Integer)this.getVersion.invoke(this.getCurrentVersion(), new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getProtocolName() {
            Set includedVersions;
            try {
                includedVersions = (Set)this.getIncludedVersions.invoke(this.getCurrentVersion(), new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            return (String)Iterables.getLast((Iterable)includedVersions);
        }
    }
}

