/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import net.earthcomputer.clientcommands.ClientCommands;
import net.earthcomputer.clientcommands.command.ListenCommand;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraft.class_156;
import net.minecraft.class_3797;
import net.minecraft.class_8144;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class MappingsHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path MAPPINGS_DIR = ClientCommands.CONFIG_DIR.resolve("mappings");
    private static final boolean IS_DEV_ENV = FabricLoader.getInstance().isDevelopmentEnvironment();
    private static final CompletableFuture<MemoryMappingTree> mojmapOfficial;
    private static final int SRC_OFFICIAL = 0;
    private static final int DEST_OFFICIAL = 0;
    private static final MemoryMappingTree officialIntermediaryNamed;
    private static final int SRC_INTERMEDIARY = 0;
    private static final int DEST_INTERMEDIARY = 0;
    private static final int SRC_NAMED = 1;
    private static final int DEST_NAMED = 1;

    private MappingsHelper() {
    }

    public static void load() {
    }

    public static @Nullable Collection<? extends // Could not load outer class - annotation placement on inner may be incorrect
    MappingTree.ClassMapping> mojmapClasses() {
        return (Collection)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), MemoryMappingTree::getClasses);
    }

    public static @Nullable String mojmapToOfficial_class(String mojmapClass) {
        MappingTree.ClassMapping officialClass = (MappingTree.ClassMapping)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), tree -> tree.getClass(mojmapClass));
        if (officialClass == null) {
            return null;
        }
        return officialClass.getDstName(0);
    }

    public static @Nullable String officialToMojmap_class(String officialClass) {
        MappingTree.ClassMapping mojmapClass = (MappingTree.ClassMapping)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), tree -> tree.getClass(officialClass, 0));
        if (mojmapClass == null) {
            return null;
        }
        return mojmapClass.getSrcName();
    }

    public static @Nullable String mojmapToNamed_class(String mojmapClass) {
        String officialClass = MappingsHelper.mojmapToOfficial_class(mojmapClass);
        if (officialClass == null) {
            return null;
        }
        MappingTree.ClassMapping namedClass = officialIntermediaryNamed.getClass(officialClass);
        if (namedClass == null) {
            return null;
        }
        return namedClass.getDstName(1);
    }

    public static @Nullable String namedToMojmap_class(String namedClass) {
        MappingTree.ClassMapping officialClass = officialIntermediaryNamed.getClass(namedClass, 1);
        if (officialClass == null) {
            return null;
        }
        MappingTree.ClassMapping mojmapClass = (MappingTree.ClassMapping)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), tree -> tree.getClass(officialClass.getSrcName(), 0));
        if (mojmapClass == null) {
            return null;
        }
        return mojmapClass.getSrcName();
    }

    public static @Nullable String mojmapToIntermediary_class(String mojmapClass) {
        String officialClass = MappingsHelper.mojmapToOfficial_class(mojmapClass);
        if (officialClass == null) {
            return null;
        }
        MappingTree.ClassMapping intermediaryClass = officialIntermediaryNamed.getClass(officialClass);
        if (intermediaryClass == null) {
            return null;
        }
        return intermediaryClass.getDstName(0);
    }

    public static @Nullable String intermediaryToMojmap_class(String intermediaryClass) {
        MappingTree.ClassMapping officialClass = officialIntermediaryNamed.getClass(intermediaryClass, 0);
        if (officialClass == null) {
            return null;
        }
        MappingTree.ClassMapping mojmapClass = (MappingTree.ClassMapping)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), tree -> tree.getClass(officialClass.getSrcName(), 0));
        if (mojmapClass == null) {
            return null;
        }
        return mojmapClass.getSrcName();
    }

    public static @Nullable String namedOrIntermediaryToMojmap_class(String namedOrIntermediaryClass) {
        if (IS_DEV_ENV) {
            return MappingsHelper.namedToMojmap_class(namedOrIntermediaryClass);
        }
        return MappingsHelper.intermediaryToMojmap_class(namedOrIntermediaryClass);
    }

    public static @Nullable String mojmapToNamedOrIntermediary_class(String mojmapClass) {
        if (IS_DEV_ENV) {
            return MappingsHelper.mojmapToNamed_class(mojmapClass);
        }
        return MappingsHelper.mojmapToIntermediary_class(mojmapClass);
    }

    public static @Nullable String officialToMojmap_field(String officialClass, String officialField) {
        MappingTree.FieldMapping mojmapField = (MappingTree.FieldMapping)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), tree -> tree.getField(officialClass, officialField, null));
        if (mojmapField == null) {
            return null;
        }
        return mojmapField.getSrcName();
    }

    public static @Nullable String namedToMojmap_field(String namedClass, String namedField) {
        MappingTree.ClassMapping officialClass = officialIntermediaryNamed.getClass(namedClass, 1);
        if (officialClass == null) {
            return null;
        }
        MappingTree.FieldMapping officialField = officialIntermediaryNamed.getField(namedClass, namedField, null, 1);
        if (officialField == null) {
            return null;
        }
        MappingTree.FieldMapping mojmapField = (MappingTree.FieldMapping)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), tree -> tree.getField(officialClass.getSrcName(), officialField.getSrcName(), null, 0));
        if (mojmapField == null) {
            return null;
        }
        return mojmapField.getSrcName();
    }

    public static @Nullable String intermediaryToMojmap_field(String intermediaryClass, String intermediaryField) {
        MappingTree.ClassMapping officialClass = officialIntermediaryNamed.getClass(intermediaryClass, 0);
        if (officialClass == null) {
            return null;
        }
        MappingTree.FieldMapping officialField = officialIntermediaryNamed.getField(intermediaryClass, intermediaryField, null, 0);
        if (officialField == null) {
            return null;
        }
        MappingTree.FieldMapping mojmapField = (MappingTree.FieldMapping)class_8144.method_49077((Object)MappingsHelper.getMojmapOfficial(), tree -> tree.getField(officialClass.getSrcName(), officialField.getSrcName(), null, 0));
        if (mojmapField == null) {
            return null;
        }
        return mojmapField.getSrcName();
    }

    public static @Nullable String namedOrIntermediaryToMojmap_field(String namedOrIntermediaryClass, String namedOrIntermediaryField) {
        if (IS_DEV_ENV) {
            return MappingsHelper.namedToMojmap_field(namedOrIntermediaryClass, namedOrIntermediaryField);
        }
        return MappingsHelper.intermediaryToMojmap_field(namedOrIntermediaryClass, namedOrIntermediaryField);
    }

    private static @Nullable MemoryMappingTree getMojmapOfficial() {
        try {
            return mojmapOfficial.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("mojmap mappings were not available", (Throwable)e);
            ListenCommand.disable();
            return null;
        }
    }

    static {
        try {
            Files.createDirectories(MAPPINGS_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create mappings dir", (Throwable)e);
        }
        mojmapOfficial = (CompletableFuture)class_156.method_656(() -> {
            CompletableFuture<MemoryMappingTree> completableFuture;
            block14: {
                String version = class_3797.field_25319.comp_4025();
                BufferedReader reader = Files.newBufferedReader(MAPPINGS_DIR.resolve(version + ".txt"));
                try {
                    MemoryMappingTree tree = new MemoryMappingTree();
                    MappingReader.read((Reader)reader, (MappingFormat)MappingFormat.PROGUARD_FILE, (MappingVisitor)tree);
                    completableFuture = CompletableFuture.completedFuture(tree);
                    if (reader == null) break block14;
                }
                catch (Throwable t$) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (IOException e) {
                        try (HttpClient httpClient = HttpClient.newHttpClient();){
                            HttpRequest versionsRequest = HttpRequest.newBuilder().uri(URI.create("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json")).GET().timeout(Duration.ofSeconds(5L)).build();
                            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)httpClient.sendAsync(versionsRequest, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenCompose(versionsBody -> {
                                JsonObject versionsJson = JsonParser.parseString((String)versionsBody).getAsJsonObject();
                                String versionUrl = versionsJson.getAsJsonArray("versions").asList().stream().map(JsonElement::getAsJsonObject).filter(v -> v.get("id").getAsString().equals(version)).map(v -> v.get("url").getAsString()).findAny().orElseThrow();
                                HttpRequest versionRequest = HttpRequest.newBuilder().uri(URI.create(versionUrl)).GET().timeout(Duration.ofSeconds(5L)).build();
                                return httpClient.sendAsync(versionRequest, HttpResponse.BodyHandlers.ofString());
                            })).whenComplete((result, exception) -> {
                                if (exception != null) {
                                    ListenCommand.disable();
                                }
                            })).thenApply(HttpResponse::body)).thenCompose(versionBody -> {
                                JsonObject versionJson = JsonParser.parseString((String)versionBody).getAsJsonObject();
                                String mappingsUrl = versionJson.getAsJsonObject("downloads").getAsJsonObject("client_mappings").get("url").getAsString();
                                HttpRequest mappingsRequest = HttpRequest.newBuilder().uri(URI.create(mappingsUrl)).GET().timeout(Duration.ofSeconds(5L)).build();
                                return httpClient.sendAsync(mappingsRequest, HttpResponse.BodyHandlers.ofString());
                            })).thenApply(HttpResponse::body)).thenApply(body -> {
                                StringReader reader = new StringReader((String)body);
                                MemoryMappingTree tree = new MemoryMappingTree();
                                MappingReader.read((Reader)reader, (MappingFormat)MappingFormat.PROGUARD_FILE, (MappingVisitor)tree);
                                MemoryMappingTree memoryMappingTree = tree;
                                reader.close();
                                try (BufferedWriter writer = Files.newBufferedWriter(MAPPINGS_DIR.resolve(version + ".txt"), StandardOpenOption.CREATE);){
                                    writer.write((String)body);
                                }
                                catch (IOException ex) {
                                    LOGGER.error("Could not write ProGuard mappings file", (Throwable)ex);
                                }
                                return memoryMappingTree;
                                {
                                    catch (Throwable t$) {
                                        try {
                                            try {
                                                try {
                                                    reader.close();
                                                }
                                                catch (Throwable x2) {
                                                    t$.addSuppressed(x2);
                                                }
                                                throw t$;
                                            }
                                            catch (IOException ex) {
                                                LOGGER.error("Could not read ProGuard mappings file", (Throwable)ex);
                                                ListenCommand.disable();
                                                throw new UncheckedIOException(ex);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            try (BufferedWriter writer = Files.newBufferedWriter(MAPPINGS_DIR.resolve(version + ".txt"), StandardOpenOption.CREATE);){
                                                writer.write((String)body);
                                            }
                                            catch (IOException ex) {
                                                LOGGER.error("Could not write ProGuard mappings file", (Throwable)ex);
                                            }
                                            throw throwable;
                                        }
                                    }
                                }
                            });
                            return completionStage;
                        }
                    }
                }
                reader.close();
            }
            return completableFuture;
        });
        officialIntermediaryNamed = (MemoryMappingTree)class_156.method_656(() -> {
            MemoryMappingTree memoryMappingTree;
            block9: {
                InputStream stream = FabricLoader.class.getClassLoader().getResourceAsStream("mappings/mappings.tiny");
                try {
                    if (stream == null) {
                        throw new IOException("Could not find mappings.tiny");
                    }
                    MemoryMappingTree tree = new MemoryMappingTree();
                    MappingReader.read((Reader)new InputStreamReader(stream), (MappingFormat)(IS_DEV_ENV ? MappingFormat.TINY_2_FILE : MappingFormat.TINY_FILE), (MappingVisitor)tree);
                    memoryMappingTree = tree;
                    if (stream == null) break block9;
                }
                catch (Throwable t$) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not read mappings.tiny", (Throwable)e);
                        ListenCommand.disable();
                        return null;
                    }
                }
                stream.close();
            }
            return memoryMappingTree;
        });
    }
}

