/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.earthcomputer.clientcommands.task.LongTask;

public class LongTaskList
extends LongTask {
    private final List<LongTask> children = new ArrayList<LongTask>();

    public void addTask(LongTask task) {
        this.children.add(task);
    }

    @Override
    public void initialize() {
        if (!this.children.isEmpty()) {
            this.children.getFirst().initialize();
        }
    }

    @Override
    public boolean condition() {
        return !this.children.isEmpty();
    }

    @Override
    public void increment() {
    }

    @Override
    public void body() {
        LongTask child = this.children.getFirst();
        if (child.isCompleted()) {
            child.onCompleted();
            if (child.isDelayScheduled()) {
                this.scheduleDelay();
            }
            this.children.removeFirst();
            if (!this.isCompleted()) {
                this.children.getFirst().initialize();
            }
        } else {
            child.body();
            if (!child.isCompleted()) {
                child.increment();
            }
            if (child.isDelayScheduled()) {
                child.unscheduleDelay();
                this.scheduleDelay();
            }
        }
    }

    @Override
    public boolean stopOnLevelUnload(boolean isDisconnect) {
        boolean stop = false;
        for (LongTask child : this.children) {
            stop |= child.stopOnLevelUnload(isDisconnect);
        }
        return stop;
    }

    @Override
    public void onCompleted() {
        if (!this.children.isEmpty()) {
            this.children.getFirst().onCompleted();
        }
    }

    @Override
    public Set<Object> getMutexKeys() {
        HashSet<Object> union = new HashSet<Object>();
        for (LongTask child : this.children) {
            union.addAll(child.getMutexKeys());
        }
        return union;
    }

    public String toString() {
        Class<?> thisClass = this.getClass();
        String packageName = thisClass.getPackageName();
        String classDisplayName = packageName.isEmpty() ? thisClass.getName() : thisClass.getName().substring(packageName.length() + 1);
        return classDisplayName + String.valueOf(this.children);
    }
}

